// -*- Mode: C++; -*-
//                              File      : RDIRVMPool.cc
//                              Package   : omniNotify-Library
//                              Created on: 5-Jun-2001
//                              Authors   : gruber
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    pool of RVM, one per thread that does filter evaluation
 
/*
$Log: RDIRVMPool.cc,v $
Revision 1.3  2001/08/03 17:54:19  alcfp
added support for AttNotification

Revision 1.2  2001/06/26 20:01:21  alcfp
updated copyright notices, added support for omniORB4, switched default to POA

Revision 1.1  2001/06/12 17:55:59  alcfp
added RDIRVMPool

*/

#include "RDI.h"
#include "RDIRVMPool.h"
#include "RDIUtil.h"

// static members
RDI_Hash<int, RDI_RVM*> RDI_RVMPool::_rvms(RDI_SIntHash, RDI_SIntRank);

RDI_RVM* RDI_RVMPool::get_rvm() {
  RDI_RVM* res = 0;
  int i = omni_thread::self()->id();
  if (_rvms.lookup(i, res)) { // found it
    return res;
  }
  res = new RDI_RVM();
  RDI_AssertAllocThrowNo(res, "Memory allocation failed - RDI_RVM object");
  _rvms.insert(i, res);
  return res;
}

