// -*- Mode: C++; -*-
//                              File      : omniNotify.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    the entry point to the omniNotify library
//
 
/*
$Log: omniNotify.h,v $
Revision 1.12  2001/10/02 14:07:51  alcfp
improved error messages for command line errors

Revision 1.11  2001/08/03 17:54:16  alcfp
added support for AttNotification

Revision 1.10  2001/06/26 20:01:12  alcfp
updated copyright notices, added support for omniORB4, switched default to POA

Revision 1.9  2001/06/22 07:00:29  alcfp
moved to new logging scheme

Revision 1.8  2001/06/12 17:41:31  alcfp
minor cleanup

Revision 1.7  2000/11/16 04:20:35  alcfp
changes to make use of omniNotify.h and wrapper files consistent

Revision 1.6  2000/11/15 21:18:17  alcfp
large number of changes to switch to use of RDIOplocks for safe object disposal support.  also reduced code duplication a little, and tried hard to make all the proxy code consistent

Revision 1.5  2000/10/04 02:40:05  alcfp
small fixes to avoid some compiler warnings

Revision 1.4  2000/08/22 18:23:52  alcfp
added description to each file

Revision 1.3  2000/08/16 20:19:20  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __OMNI_NOTIFY_H__
#define __OMNI_NOTIFY_H__

#ifndef COS_USES_BOA
#include "COS/AttNotification.hh"
#else
#include "COS/BOA/AttNotification.hh"
#endif

// ---------------------------------------------------------------- //
// The following class exposes the functionality provided by the    //
// omniNotify library, i.e., creation of an AttNotification::Server //
// ---------------------------------------------------------------- //

class omniNotify {
public:
  // The first time omniNotify::init_server is called with valid arguments,
  // it initializes the omniNotify server.
  // On subsequent calls, init_server ignores the arguments and
  // simply behaves like get_server (only one server is supported per process).
  //
  // On initialization, the server creates an event channel factory and a
  // default channel, configured according to defaults and command line arguments.
  //
  // By default, these objects are named 'ChannelFactory' and 
  // 'EventChannel', respectively, and are registered with the
  // default NameService.
  //
  // Supported command line arguments include:
  // 
  //	-n      : do NOT register the event channel factory and 
  //              event channel with the NameService 
  //    -c name : use the configuration file 'name'
  // 
  // As well as arguments of the form:
  // 
  //    -Dparam_name=param_value
  // 
  // Here, 'param_name' must be a valid parameter name.  A list of
  // valid names can be found in 'channel.cfg', a configuration
  // file provided with the distribution.
  // 
  // ** Before calling init_server, the ORB and BOA/or/POA
  //    must have already been initialized using the
  //          WRAPPED_ORB_OA::init(argc, argv);
  //    call from corba_wrappers.h
  // 
  // init_server returns a reference to the resulting AttNotification::Server
  // (or a nil reference on error).

  static AttNotification::Server_ptr init_server(int& argc, char** argv);

  // get_server returns a reference to the AttNotification::Server
  // (or a nil reference if init_server has not yet been used to
  // initialize the server).
  static AttNotification::Server_ptr get_server();
};

#endif
