// -*- Mode: C++; -*-
//                              File      : omniorb_boa_wrappers_impl.h
//                              Package   : omniNotify-Library
//                              Created on: 30-Oct-2000
//                              Authors   : gruber
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
// Description:
//    wrappers hide BOA/POA differences 
 
#ifndef __OMNIORB_BOA_WRAPPERS_IMPL_H__
#define __OMNIORB_BOA_WRAPPERS_IMPL_H__

#include "omniorb_boa_wrappers.h"

CORBA::ORB_ptr WRAPPED_ORB_OA::_orb = 0;
CORBA::BOA_ptr WRAPPED_ORB_OA::_boa = 0;
CORBA::Boolean WRAPPED_ORB_OA::_invoked_impl_is_ready = 0;

void WRAPPED_ORB_OA::init(int& argc, char** argv) {
  _orb = CORBA::ORB_init(argc, argv, ORB_INIT_NAME);
  _boa = _orb->BOA_init(argc,argv, BOA_INIT_NAME);
  _invoked_impl_is_ready = 0;
}

void WRAPPED_ORB_OA::cleanup() {
  if (_boa) _boa->destroy();
  if (_orb) _orb->destroy();
  _boa = 0;
  _orb = 0;
  _invoked_impl_is_ready = 0;
}

void WRAPPED_ORB_OA::activate_oas() {
  if (!_invoked_impl_is_ready) {
    _boa->impl_is_ready(0,1);
    _invoked_impl_is_ready = 1;
  }
}

void WRAPPED_ORB_OA::run() {
  activate_oas();
  _orb->run();
}

void WRAPPED_ORB_OA::shutdown(CORBA::Boolean wait_for_completion) {
  _orb->shutdown(wait_for_completion);
}


#endif
