// -*- Mode: C++; -*-
//                              File      : RDIRVMPool.h
//                              Package   : omniNotify-Library
//                              Created on: 5-Jun-2001
//                              Authors   : gruber
//
//    Copyright (C) 1998-2001 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    pool of RVM, one per thread that does filter evaluation
 
/*
$Log: RDIRVMPool.h,v $
Revision 1.3  2001/08/03 17:54:15  alcfp
added support for AttNotification

Revision 1.2  2001/06/26 20:01:09  alcfp
updated copyright notices, added support for omniORB4, switched default to POA

Revision 1.1  2001/06/12 17:40:04  alcfp
new RVM pool

*/

#ifndef __RDI_RVM_POOL__
#define __RDI_RVM_POOL__

#include "RDIDynamicEvalDefs.h"
#include "RDIHash.h"
#include "omnithread.h"

////////////////////////////////////////////////////////////////////////////////

class RDI_RVMPool {
public:
  // Return a reference to an 'RDI_RVM' that is thread-safe;
  // the current implementation allocates an RDI_RVM per thread
  // that does filtering
  static RDI_RVM* get_rvm();
  
private:
  static RDI_Hash<int, RDI_RVM*> _rvms;
};

////////////////////////////////////////////////////////////////////////////////

#endif /* __RDI_RVM_POOL__ */
