// -*- Mode: C++; -*-
//                              File      : RDIEval.cc
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    Implementation of support functionality for EXTENDED_TCL parser
//
 
/*
$Log: RDIEval.cc,v $
Revision 1.11  2000/10/04 02:40:05  alcfp
small fixes to avoid some compiler warnings

Revision 1.10  2000/08/22 18:23:55  alcfp
added description to each file

Revision 1.9  2000/08/16 20:19:49  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#include "RDIEvalDefs.h"

////////////////////////////////////////////////////
// TABLES

const char* RDI_WKP2string[] = {
  "$",
  "header",
  "filterable_data",
  "remainder_of_body",
  "fixed_header",
  "variable_header",
  "event_name",
  "event_type",
  "type_name",
  "domain_name"
};

const char* RDI_RTRetCode2string[] = {
  "RDI_RTRet_OK",
  "RDI_RTRet_UNDEFINED",
  "RDI_RTRet_DIVIDE_BY_ZERO",
  "RDI_RTRet_OVERFLOW",
  "RDI_RTRet_OUT_OF_MEMORY",
  "RDI_RTRet_TYPE_MISMATCH",
  "RDI_RTRet_NONE_SUCH",
  "RDI_RTRet_NOT_SUPPORTED"
};

const char* RDI_OpCode2string[] = {
  "RDI_OpCode_nop",
  "RDI_OpCode_return_b",
  "RDI_OpCode_signal_l",
  "RDI_OpCode_push_sC2c",
  "RDI_OpCode_push_sC2s",
  "RDI_OpCode_push_sC2i",
  "RDI_OpCode_push_bC2b",
  "RDI_OpCode_push_lC2w",
  "RDI_OpCode_push_lC2l",
  "RDI_OpCode_push_dC2d",
  "RDI_OpCode_ctelt_lC2n",
  "RDI_OpCode_swap_uu2uu",
  "RDI_OpCode_pop_u",
  "RDI_OpCode_pop_uu",
  "RDI_OpCode_cvt_u2b",
  "RDI_OpCode_cvt_u2s",
  "RDI_OpCode_cvt_u2n",
  "RDI_OpCode_or_bb2b",
  "RDI_OpCode_and_bb2b",
  "RDI_OpCode_not_b2b",
  "RDI_OpCode_in_uu2b",
  "RDI_OpCode_add_nn2n",
  "RDI_OpCode_sub_nn2n",
  "RDI_OpCode_mul_nn2n",
  "RDI_OpCode_div_nn2n",
  "RDI_OpCode_rem_nn2n",
  "RDI_OpCode_substr_ss2b",
  "RDI_OpCode_cmp_uu2l",
  "RDI_OpCode_eqz_l2b",
  "RDI_OpCode_nez_l2b",
  "RDI_OpCode_lez_l2b",
  "RDI_OpCode_ltz_l2b",
  "RDI_OpCode_gez_l2b",
  "RDI_OpCode_gtz_l2b",
  "RDI_OpCode_ifeq_l2l",
  "RDI_OpCode_ifne_l2l",
  "RDI_OpCode_ifle_l2l",
  "RDI_OpCode_iflt_l2l",
  "RDI_OpCode_ifge_l2l",
  "RDI_OpCode_ifgt_l2l",
  "RDI_OpCode_ifT_b2b",
  "RDI_OpCode_ifF_b2b",
  "RDI_OpCode_goto",
  "RDI_OpCode_label",
  "RDI_OpCode_wkp_lC2u",
  "RDI_OpCode_special_sC2u",
  "RDI_OpCode_compend",
  "RDI_OpCode_default_X2b",
  "RDI_OpCode_exist_X2b",
  "RDI_OpCode_dot_len_u2l",
  "RDI_OpCode_dot_d_u2u",
  "RDI_OpCode_dot_tid_u2s",
  "RDI_OpCode_dot_rid_u2s",
  "RDI_OpCode_dot_id_usC2u",
  "RDI_OpCode_dot_num_ulC2u",
  "RDI_OpCode_assoc_usC2u",
  "RDI_OpCode_index_ulC2u",
  "RDI_OpCode_tagdef_u2u",
  "RDI_OpCode_tagid_usC2u",
  "RDI_OpCode_tagnum_ulC2u",
  "RDI_OpCode_tagchar_usC2u",
  "RDI_OpCode_tagbool_ubC2u",
  "RDI_OpCode_debug1",
  "RDI_OpCode_debug2"
};

// MAP OpCode -> stack prereq
const RDI_StackPre RDI_Op2StackPre[] = {
  RDI_StackPre_none,      //  RDI_OpCode_nop                
  RDI_StackPre_b,         //  RDI_OpCode_return_b           
  RDI_StackPre_l,         //  RDI_OpCode_signal_l           
  RDI_StackPre_none,      //  RDI_OpCode_push_sC2c          
  RDI_StackPre_none,      //  RDI_OpCode_push_sC2s          
  RDI_StackPre_none,      //  RDI_OpCode_push_sC2i          
  RDI_StackPre_none,      //  RDI_OpCode_push_bC2b          
  RDI_StackPre_none,      //  RDI_OpCode_push_lC2w          
  RDI_StackPre_none,      //  RDI_OpCode_push_lC2l          
  RDI_StackPre_none,      //  RDI_OpCode_push_dC2d          
  RDI_StackPre_none,      //  RDI_OpCode_ctelt_lC2n         
  RDI_StackPre_XX,        //  RDI_OpCode_swap_uu2uu         
  RDI_StackPre_X,         //  RDI_OpCode_pop_u              
  RDI_StackPre_XX,        //  RDI_OpCode_pop_uu             
  RDI_StackPre_u,         //  RDI_OpCode_cvt_u2b            
  RDI_StackPre_u,         //  RDI_OpCode_cvt_u2s            
  RDI_StackPre_X,         //  RDI_OpCode_cvt_u2n            
  RDI_StackPre_bb,        //  RDI_OpCode_or_bb2b            
  RDI_StackPre_bb,        //  RDI_OpCode_and_bb2b           
  RDI_StackPre_b,         //  RDI_OpCode_not_b2b            
  RDI_StackPre_Xu,        //  RDI_OpCode_in_uu2b            
  RDI_StackPre_nn,        //  RDI_OpCode_add_nn2n           
  RDI_StackPre_nn,        //  RDI_OpCode_sub_nn2n           
  RDI_StackPre_nn,        //  RDI_OpCode_mul_nn2n           
  RDI_StackPre_nn,        //  RDI_OpCode_div_nn2n           
  RDI_StackPre_nn,        //  RDI_OpCode_rem_nn2n           
  RDI_StackPre_ss,        //  RDI_OpCode_substr_ss2b        
  RDI_StackPre_XX,        //  RDI_OpCode_cmp_uu2l           
  RDI_StackPre_l,         //  RDI_OpCode_eqz_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_nez_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_lez_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_ltz_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_gez_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_gtz_l2b            
  RDI_StackPre_l,         //  RDI_OpCode_ifeq_l2l             
  RDI_StackPre_l,         //  RDI_OpCode_ifne_l2l             
  RDI_StackPre_l,         //  RDI_OpCode_ifle_l2l             
  RDI_StackPre_l,         //  RDI_OpCode_iflt_l2l             
  RDI_StackPre_l,         //  RDI_OpCode_ifge_l2l             
  RDI_StackPre_l,         //  RDI_OpCode_ifgt_l2l             
  RDI_StackPre_b,         //  RDI_OpCode_ifT_b2b            
  RDI_StackPre_b,         //  RDI_OpCode_ifF_b2b          
  RDI_StackPre_none,      //  RDI_OpCode_goto               
  RDI_StackPre_none,      //  RDI_OpCode_label               
  RDI_StackPre_none,      //  RDI_OpCode_wkp_lC2u          
  RDI_StackPre_none,      //  RDI_OpCode_special_sC2u       
  RDI_StackPre_X,         //  RDI_OpCode_compend               
  RDI_StackPre_X,         //  RDI_OpCode_default_X2b        
  RDI_StackPre_X,         //  RDI_OpCode_exist_X2b          
  RDI_StackPre_u,         //  RDI_OpCode_dot_len_u2l        
  RDI_StackPre_u,         //  RDI_OpCode_dot_d_u2u          
  RDI_StackPre_u,         //  RDI_OpCode_dot_tid_u2s        
  RDI_StackPre_u,         //  RDI_OpCode_dot_rid_u2s        
  RDI_StackPre_u,         //  RDI_OpCode_dot_id_usC2u       
  RDI_StackPre_u,         //  RDI_OpCode_dot_num_ulC2u      
  RDI_StackPre_u,         //  RDI_OpCode_assoc_usC2u        
  RDI_StackPre_u,         //  RDI_OpCode_index_ulC2u        
  RDI_StackPre_u,         //  RDI_OpCode_tagdef_u2u         
  RDI_StackPre_u,         //  RDI_OpCode_tagid_usC2u        
  RDI_StackPre_u,         //  RDI_OpCode_tagnum_ulC2u       
  RDI_StackPre_u,         //  RDI_OpCode_tagchar_usC2u      
  RDI_StackPre_u,         //  RDI_OpCode_tagbool_ubC2u      
  RDI_StackPre_none,      //  RDI_OpCode_debug1             
  RDI_StackPre_none       //  RDI_OpCode_debug2             
};

// MAP OpCode -> change in top of stack
const RDI_StackEffect RDI_Op2StackEffect[] = {
  RDI_StackEffect_none,   //  RDI_OpCode_nop                  
  RDI_StackEffect_none,   //  RDI_OpCode_return_b             
  RDI_StackEffect_none,   //  RDI_OpCode_signal_l             
  RDI_StackEffect_2c,     //  RDI_OpCode_push_sC2c            
  RDI_StackEffect_2s,     //  RDI_OpCode_push_sC2s            
  RDI_StackEffect_2i,     //  RDI_OpCode_push_sC2i            
  RDI_StackEffect_2b,     //  RDI_OpCode_push_bC2b            
  RDI_StackEffect_2w,     //  RDI_OpCode_push_lC2w            
  RDI_StackEffect_2l,     //  RDI_OpCode_push_lC2l            
  RDI_StackEffect_2d,     //  RDI_OpCode_push_dC2d            
  RDI_StackEffect_2n,     //  RDI_OpCode_ctelt_lC2n           
  RDI_StackEffect_swap,   //  RDI_OpCode_swap_uu2uu           
  RDI_StackEffect_X,      //  RDI_OpCode_pop_u                
  RDI_StackEffect_XX,     //  RDI_OpCode_pop_uu               
  RDI_StackEffect_X2b,    //  RDI_OpCode_cvt_u2b              
  RDI_StackEffect_X2s,    //  RDI_OpCode_cvt_u2s              
  RDI_StackEffect_X2n,    //  RDI_OpCode_cvt_u2n              
  RDI_StackEffect_XX2b,   //  RDI_OpCode_or_bb2b              
  RDI_StackEffect_XX2b,   //  RDI_OpCode_and_bb2b             
  RDI_StackEffect_X2b,    //  RDI_OpCode_not_b2b              
  RDI_StackEffect_XX2b,   //  RDI_OpCode_in_uu2b              
  RDI_StackEffect_XX2n,   //  RDI_OpCode_add_nn2n             
  RDI_StackEffect_XX2n,   //  RDI_OpCode_sub_nn2n             
  RDI_StackEffect_XX2n,   //  RDI_OpCode_mul_nn2n             
  RDI_StackEffect_XX2n,   //  RDI_OpCode_div_nn2n             
  RDI_StackEffect_XX2n,   //  RDI_OpCode_rem_nn2n             
  RDI_StackEffect_XX2b,   //  RDI_OpCode_substr_ss2b          
  RDI_StackEffect_XX2l,   //  RDI_OpCode_cmp_uu2l             
  RDI_StackEffect_X2b,    //  RDI_OpCode_eqz_l2b              
  RDI_StackEffect_X2b,    //  RDI_OpCode_nez_l2b              
  RDI_StackEffect_X2b,    //  RDI_OpCode_lez_l2b              
  RDI_StackEffect_X2b,    //  RDI_OpCode_ltz_l2b              
  RDI_StackEffect_X2b,    //  RDI_OpCode_gez_l2b              
  RDI_StackEffect_X2b,    //  RDI_OpCode_gtz_l2b              
  RDI_StackEffect_none,   //  RDI_OpCode_ifeq_l2l               
  RDI_StackEffect_none,   //  RDI_OpCode_ifne_l2l               
  RDI_StackEffect_none,   //  RDI_OpCode_ifle_l2l               
  RDI_StackEffect_none,   //  RDI_OpCode_iflt_l2l               
  RDI_StackEffect_none,   //  RDI_OpCode_ifge_l2l               
  RDI_StackEffect_none,   //  RDI_OpCode_ifgt_l2l              
  RDI_StackEffect_none,   //  RDI_OpCode_ifT_b2b               
  RDI_StackEffect_none,   //  RDI_OpCode_ifF_b2b               
  RDI_StackEffect_none,   //  RDI_OpCode_goto                 
  RDI_StackEffect_none,   //  RDI_OpCode_label                 
  RDI_StackEffect_2u,     //  RDI_OpCode_wkp_lC2u            
  RDI_StackEffect_2u,     //  RDI_OpCode_special_sC2u         
  RDI_StackEffect_none,   //  RDI_OpCode_compend
  RDI_StackEffect_X2b,    //  RDI_OpCode_default_X2b          
  RDI_StackEffect_X2b,    //  RDI_OpCode_exist_X2b            
  RDI_StackEffect_X2l,    //  RDI_OpCode_dot_len_u2l          
  RDI_StackEffect_X2u,    //  RDI_OpCode_dot_d_u2u            
  RDI_StackEffect_X2s,    //  RDI_OpCode_dot_tid_u2s          
  RDI_StackEffect_X2s,    //  RDI_OpCode_dot_rid_u2s          
  RDI_StackEffect_X2u,    //  RDI_OpCode_dot_id_usC2u         
  RDI_StackEffect_X2u,    //  RDI_OpCode_dot_num_ulC2u        
  RDI_StackEffect_X2u,    //  RDI_OpCode_assoc_usC2u          
  RDI_StackEffect_X2u,    //  RDI_OpCode_index_ulC2u          
  RDI_StackEffect_X2u,    //  RDI_OpCode_tagdef_u2u           
  RDI_StackEffect_X2u,    //  RDI_OpCode_tagid_usC2u          
  RDI_StackEffect_X2u,    //  RDI_OpCode_tagnum_ulC2u         
  RDI_StackEffect_X2u,    //  RDI_OpCode_tagchar_usC2u        
  RDI_StackEffect_X2u,    //  RDI_OpCode_tagbool_ubC2u        
  RDI_StackEffect_none,   //  RDI_OpCode_debug1               
  RDI_StackEffect_none    //  RDI_OpCode_debug2               
};

// MAP OpCode -> required argument for this kind of op
const RDI_OpArgT RDI_Op2ArgT[] = {
  RDI_OpArgT_none,     //  RDI_OpCode_nop                
  RDI_OpArgT_none,     //  RDI_OpCode_return_b           
  RDI_OpArgT_none,     //  RDI_OpCode_signal_l           
  RDI_OpArgT_sc,       //  RDI_OpCode_push_sC2c          
  RDI_OpArgT_sc,       //  RDI_OpCode_push_sC2s          
  RDI_OpArgT_sc,       //  RDI_OpCode_push_sC2i          
  RDI_OpArgT_bc,       //  RDI_OpCode_push_bC2b          
  RDI_OpArgT_lc,       //  RDI_OpCode_push_lC2w          
  RDI_OpArgT_lc,       //  RDI_OpCode_push_lC2l          
  RDI_OpArgT_dc,       //  RDI_OpCode_push_dC2d          
  RDI_OpArgT_lc,       //  RDI_OpCode_ctelt_lC2n         
  RDI_OpArgT_none,     //  RDI_OpCode_swap_uu2uu         
  RDI_OpArgT_none,     //  RDI_OpCode_pop_u              
  RDI_OpArgT_none,     //  RDI_OpCode_pop_uu             
  RDI_OpArgT_none,     //  RDI_OpCode_cvt_u2b            
  RDI_OpArgT_none,     //  RDI_OpCode_cvt_u2s            
  RDI_OpArgT_none,     //  RDI_OpCode_cvt_u2n            
  RDI_OpArgT_none,     //  RDI_OpCode_or_bb2b            
  RDI_OpArgT_none,     //  RDI_OpCode_and_bb2b           
  RDI_OpArgT_none,     //  RDI_OpCode_not_b2b            
  RDI_OpArgT_none,     //  RDI_OpCode_in_uu2b            
  RDI_OpArgT_none,     //  RDI_OpCode_add_nn2n           
  RDI_OpArgT_none,     //  RDI_OpCode_sub_nn2n           
  RDI_OpArgT_none,     //  RDI_OpCode_mul_nn2n           
  RDI_OpArgT_none,     //  RDI_OpCode_div_nn2n           
  RDI_OpArgT_none,     //  RDI_OpCode_rem_nn2n           
  RDI_OpArgT_none,     //  RDI_OpCode_substr_ss2b        
  RDI_OpArgT_none,     //  RDI_OpCode_cmp_uu2l           
  RDI_OpArgT_none,     //  RDI_OpCode_eqz_l2b            
  RDI_OpArgT_none,     //  RDI_OpCode_nez_l2b            
  RDI_OpArgT_none,     //  RDI_OpCode_lez_l2b            
  RDI_OpArgT_none,     //  RDI_OpCode_ltz_l2b            
  RDI_OpArgT_none,     //  RDI_OpCode_gez_l2b            
  RDI_OpArgT_none,     //  RDI_OpCode_gtz_l2b            
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifeq_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifne_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifle_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_iflt_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifge_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifgt_l2l             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifT_b2b             
  RDI_OpArgT_lbl,      //  RDI_OpCode_ifF_b2b             
  RDI_OpArgT_lbl,      //  RDI_OpCode_goto               
  RDI_OpArgT_sc,       //  RDI_OpCode_label               
  RDI_OpArgT_lc,       //  RDI_OpCode_wkp_lC2u          
  RDI_OpArgT_sc,       //  RDI_OpCode_special_sC2u       
  RDI_OpArgT_none,     //  RDI_OpCode_compend
  RDI_OpArgT_none,     //  RDI_OpCode_default_X2b        
  RDI_OpArgT_none,     //  RDI_OpCode_exist_X2b          
  RDI_OpArgT_none,     //  RDI_OpCode_dot_len_u2l        
  RDI_OpArgT_none,     //  RDI_OpCode_dot_d_u2u          
  RDI_OpArgT_none,     //  RDI_OpCode_dot_tid_u2s        
  RDI_OpArgT_none,     //  RDI_OpCode_dot_rid_u2s        
  RDI_OpArgT_sc,       //  RDI_OpCode_dot_id_usC2u       
  RDI_OpArgT_lc,       //  RDI_OpCode_dot_num_ulC2u      
  RDI_OpArgT_sc,       //  RDI_OpCode_assoc_usC2u        
  RDI_OpArgT_lc,       //  RDI_OpCode_index_ulC2u        
  RDI_OpArgT_none,     //  RDI_OpCode_tagdef_u2u         
  RDI_OpArgT_sc,       //  RDI_OpCode_tagid_usC2u        
  RDI_OpArgT_lc,       //  RDI_OpCode_tagnum_ulC2u       
  RDI_OpArgT_sc,       //  RDI_OpCode_tagchar_usC2u      
  RDI_OpArgT_bc,       //  RDI_OpCode_tagbool_ubC2u      
  RDI_OpArgT_none,     //  RDI_OpCode_debug1             
  RDI_OpArgT_none      //  RDI_OpCode_debug2             
};

///////////////////////////////////////////////////////////////////////////////////////////////
// RDI_Op

// simple label generator

int   RDI_Op::_newlblctr = 0;

// NB buf assumed to have len RDI_Eval_LBLBUF_LEN
void RDI_Op::newlblnm(const char* s, char buf[]) {
  RDI_Assert(strlen(s)+12 < RDI_Eval_LBLBUF_LEN, "just being careful");
  sprintf(buf, "LBL_%s_%d", s, _newlblctr++);
}

// debugging
void RDI_Op::dbg_output(bool signal_const) {
  __RDI_ADUMP_2_WRAPPED(false, RDI_OpCode2string[_code] << " ");

  if (signal_const) {
    RDI_Assert(_code == RDI_OpCode_push_lC2l, "");
    switch (_arg._v_lc) {
    case RDI_RTRet_OK:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_OK");
      break;
    case RDI_RTRet_UNDEFINED:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_UNDEFINED");
      break;
    case RDI_RTRet_DIVIDE_BY_ZERO:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_DIVIDE_BY_ZERO");
      break;
    case RDI_RTRet_OVERFLOW:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_OVERFLOW");
      break;
    case RDI_RTRet_OUT_OF_MEMORY:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_OUT_OF_MEMORY");
      break; 
    case RDI_RTRet_TYPE_MISMATCH:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_TYPE_MISMATCH");
      break;
    case RDI_RTRet_NONE_SUCH:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_NONE_SUCH");
      break;
    case RDI_RTRet_NOT_SUPPORTED:
      __RDI_ADUMP_2_WRAPPED(true, "RDI_RTRet_NOT_SUPPORTED");
      break;
    }
    return;
  }

  switch (_argT) {
  case RDI_OpArgT_none:
    // no arg
    __RDI_ADUMP_2_WRAPPED(true, "");
    break;
  case RDI_OpArgT_sc:
    // string const
    __RDI_ADUMP_2_WRAPPED(true, "sc:\"" << _arg._v_sc << "\"");
    break;
  case RDI_OpArgT_bc:
    if (_arg._v_bc) {
      __RDI_ADUMP_2_WRAPPED(true, "bc:TRUE");
    } else {
      __RDI_ADUMP_2_WRAPPED(true, "bc:FALSE");
    }
    break;
  case RDI_OpArgT_lc:
    __RDI_ADUMP_2_WRAPPED(true, "lc:" << _arg._v_lc);
    break;
  case RDI_OpArgT_dc:
    __RDI_ADUMP_2_WRAPPED(true, "dc:" << _arg._v_dc);
    break;
  case RDI_OpArgT_lbl:
    __RDI_ADUMP_2_WRAPPED(true, "lbl: " << _arg._v_lbl._lbl << "(offset " << _arg._v_lbl._offset << ")");
    break;
  }
}

