// -*- Mode: C++; -*-
//                              File      : CosNaming_i.cc
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    Implementation of CosNaming_i [Naming Service wrapper]
//
 
/*
$Log: CosNaming_i.cc,v $
Revision 1.4  2000/08/22 18:23:53  alcfp
added description to each file

Revision 1.3  2000/08/16 20:19:25  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#include <string.h>
#include "CosNaming_i.h"

CosNaming_i::CosNaming_i(char separ) : _separator(separ)
{ _rtcontext = CosNaming::NamingContext::_nil(); }

CosNaming_i::~CosNaming_i()
{ _rtcontext = CosNaming::NamingContext::_nil(); }

void CosNaming_i::bind(const char* objName, CORBA::Object_ptr objRef, int force)
{
  CosNaming::Name name;
  try {
     if ( CORBA::is_nil(_rtcontext) )
	initialize();
     makeName(objName, name);
     if ( force ) {
        _rtcontext->rebind(name, objRef);
     } else {
   	_rtcontext->bind(name, objRef);	
     }
  } catch ( ... ) {
     throw;
  }
}

void CosNaming_i::unbind(const char* objName)
{
  CosNaming::Name name;
  try {
     if ( CORBA::is_nil(_rtcontext) )
	initialize();
     makeName(objName, name);
     _rtcontext->unbind(name);
  } catch ( ... ) {
     throw;
  }
}

CORBA::Object_ptr CosNaming_i::lookup(const char* objName)
{
  CosNaming::Name   name;
  CORBA::Object_ptr objp;
  try {
     if ( CORBA::is_nil(_rtcontext) )
	initialize();
     makeName(objName, name);
     objp = _rtcontext->resolve(name);
  } catch ( ... ) {
     throw;
  }
  return objp;
}

void CosNaming_i::initialize()
{
  int argc = 0;
  try {
     CORBA::ORB_var    orb = WRAPPED_ORB_INIT(argc, 0);
     CORBA::Object_var nms = 
			WRAPPED_RESOLVE_INITIAL_REFERENCES(orb, "NameService"); 
     _rtcontext = CosNaming::NamingContext::_narrow(nms);
     if ( CORBA::is_nil(_rtcontext) ) {
	throw CORBA::BAD_PARAM(0, CORBA::COMPLETED_NO);
     }
  } catch ( ... ) {
     throw;
  }
}

void CosNaming_i::makeName(const char* objName, CosNaming::Name& name) const 
{
  register char *cptr = 0, *nptr = 0;
  register CORBA::ULong cntr = 0;
  register CORBA::ULong indx = 0;
  char* fullName = new char[ strlen(objName) + 1];
  strcpy(fullName, objName);

  for ( cptr = fullName; *cptr != '\0'; ++cptr ) {
     if ( *cptr == _separator )
	cntr += 1;
  }

  name.length(cntr + 1);
  cptr = fullName;
  nptr = fullName;

  for ( indx = 0; indx < cntr; indx++ ) {
     while ( *nptr != _separator )
	++nptr;
     *nptr = '\0';
     name[indx].id   = CORBA::string_dup(cptr);
     name[indx].kind = CORBA::string_dup(cptr);
     cptr = ++nptr;
  }
  name[indx].id   = CORBA::string_dup(cptr);
  name[indx].kind = CORBA::string_dup(cptr);
  delete [] fullName;
}
