// -*- Mode: C++; -*-
//                              File      : RDI.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDI.h,v $
Revision 1.9  2000/08/22 18:23:48  alcfp
added description to each file

Revision 1.8  2000/08/16 20:19:04  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __RDI_H__
#define __RDI_H__

#if defined (__OMNIORB3__)
#   include <omniORB3/CORBA.h>
#elif defined (__OMNIORB2__)
#   include <omniORB2/CORBA.h>
#elif defined (__ORBIX3__)
#   include "CORBA.h"
#endif

// ----------------------------------------------------------- //
// The following class provides a convinient way to access the //
// underlying ORB and BOA objects. The assumption we make here //
// is that 'RDI::Init(orb, boa)' is called after 'orb' / 'boa' //
// are initialized and before any CORBA objects are created.   //
// In addition to the above,  '_elk' is used to decide whether //
// atomic access to each event is required.                    //
// ----------------------------------------------------------- // 

class RDI {
public:
  static void init(CORBA::ORB_ptr o, CORBA::BOA_ptr b) { _orb = o; _boa = b; }

  static CORBA::ORB_ptr orb(void) 	{ return _orb; }
  static CORBA::BOA_ptr boa(void) 	{ return _boa; }
  static unsigned char  lockEvent(void)	{ return _elk; }

private:
  static CORBA::ORB_ptr _orb;
  static CORBA::BOA_ptr _boa;
  static unsigned char  _elk;
};

#endif
