// This application implements a pull consumer that connects
// to a PULL_STRUCTURED proxy.
// It consumes CosNotification::StructuredEvent events which
// have a CORBA::ULong value in the remainder_of_body field.
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>

#include "corba_wrappers.h"

#include "CosNotify.h"
#include "CosNotifyComm_i.h"

static void usage(const char* pname)
{
   cout << "Usage: " << pname << " [-d numb] [-n name] [-v]" << endl;
   cout << "       -d numb : disconnect after numb pulls" << endl;
   cout << "       -n name : channel name [\"EventChannel\"]" << endl;
   cout << "       -v      : verbose output mode" << endl;
}

int main(int argc, char** argv)
{
  CosNA_StructuredProxyPullSupplier_var supp;
  CosNA_EventChannel_var channel;
  CosN_StructuredEvent* evnt = 0;
  StructuredPullConsumer_i* cons = 0;
  char *channelName = (char *) "EventChannel";
  char *channelKind = (char *) "EventChannel";
  CORBA::Boolean verbose = 0;
  int c, num_pulls=10;

  // Parse command line arguments and initialize global variables

  while ( (c = getopt(argc, argv,"d:n:v")) != EOF ) {
  	switch (c) {
        case 'd': num_pulls = atoi(optarg);
                  cout << "# events to be consumed = " << num_pulls << endl;
                  break;
        case 'n': channelName = optarg;
		  channelKind = optarg;
                  break;
	case 'v': verbose = 1;
                  break;
        default : usage(argv[0]);
                  exit(-1);
     }
  }

  CORBA::ORB_ptr orb = WRAPPED_ORB_INIT(argc, argv);
  CORBA::BOA_ptr boa = WRAPPED_BOA_INIT(orb, argc, argv);

  cons = new StructuredPullConsumer_i();


  WRAPPED_IMPL_IS_READY_FORK(boa, "stuct_pull_consumer");

  try {
	CosNaming::Name                          name;
        CORBA::Object_var                        echannel_ref;
        CORBA::Object_var                        name_service;
        CosNaming::NamingContext_var             name_context;
        CosNA_AdminID           caID;
        CosNA_ProxyID           pxID;
        CosNA_ConsumerAdmin_var cadmin;

	if ( verbose )
		cout << "Resolving reference to: 'NameService'" << endl;
	name_service = WRAPPED_RESOLVE_INITIAL_REFERENCES(orb, "NameService"); 
	name_context = CosNaming::NamingContext::_narrow(name_service);
	if ( CORBA::is_nil(name_context) ) {
		cerr << "Failed to obtain context for NameService" << endl;
		exit(1);
        }
        name.length(1);
        name[0].id   = CORBA::string_dup(channelName);
        name[0].kind = CORBA::string_dup(channelKind);
	if ( verbose )
                cout << "Resolving reference to: '"<<channelName<<"'" << endl;
        echannel_ref = name_context->resolve(name);
        channel = CosNA_EventChannel::_narrow(echannel_ref);
        if ( CORBA::is_nil(channel) ) {
                cerr << "Failed to narrow Event Channel !" << endl;
                exit(1);
        }

	if ( verbose )
                cout << "Creating new ConsumerAdmin object" << endl;
        cadmin = channel->new_for_consumers(CosNA_AND_OP,caID);
        if ( CORBA::is_nil(cadmin) ) {
                cerr << "Failed to find Consumer Admin !" << endl;
                exit(1);
        }
        if ( verbose )
                cout << "Created ConsumerAdmin with ID " << caID << endl;

        CosNA_ProxySupplier_var psupp;
	if ( verbose )
		cout << "Creating proxy for StructuredSupplier" << endl;
	psupp=cadmin->obtain_notification_pull_supplier(
				CosNA_STRUCTURED_EVENT, pxID);
	supp=CosNA_StructuredProxyPullSupplier::_narrow(psupp);
	if ( CORBA::is_nil(supp) ) {
		cerr << "Failed to find Proxy Supplier !" << endl;
		exit(-1);
        }
	if ( verbose ) {
                cout << "Created proxy with ID " << pxID << endl;
                cout << "Connecting consumer object to proxy" << endl;
        }
        supp->obtain_offered_types(CosNA_NONE_NOW_UPDATES_ON);
        supp->connect_structured_pull_consumer(cons->_this());

	CosN_EventTypeSeq added; added.length(3);
	CosN_EventTypeSeq deled; deled.length(0);
	added[0].domain_name = (const char *) "Test";
	added[0].type_name   = (const char *) "Type 1";
	added[1].domain_name = (const char *) "Stock";
	added[1].type_name   = (const char *) "*";
	added[2].domain_name = (const char *) "Domain";
	added[2].type_name   = (const char *) "Type";
	supp->subscription_change(added, deled);

  	for (int i=0; i < num_pulls; i++) {
		evnt = supp->pull_structured_event();
		if ( verbose ) {
		   cout << setw(4) << i << " : " << 
	   (const char *) evnt->header.fixed_header.event_type.domain_name <<
	   "::" <<
	   (const char *) evnt->header.fixed_header.event_type.type_name<<endl;
		}
		delete evnt;
		if ( (i + 1) % 10 == 0 ) {
			char name[24];
			deled.length(2);
			deled[0].domain_name = added[2].domain_name;
        		deled[0].type_name   = added[2].type_name;
			deled[1].domain_name = (const char *) "Random";
                        deled[1].type_name   = (const char *) "Type";
			added[0].domain_name = (const char *) "Test";
			added[0].type_name   = (const char *) "Type 1";
			added[1].domain_name = (const char *) "Stock";
        		added[1].type_name   = (const char *) "*";
			sprintf(name, "Domain %d", i);
        		added[2].domain_name = (const char *) name;
			sprintf(name, "Type %d", i);
        		added[2].type_name   = (const char *) name;
			supp->subscription_change(added, deled);
		}
	}

	if ( verbose )
		cout << "Disconnecting consumer from channel" << endl;
	supp->disconnect_structured_pull_supplier();
  	cadmin->destroy();
  } catch(CORBA::ORB::InvalidName& ex) {
        cerr << "Service required is invalid [does not exist]" << endl;
        exit(1);
#if defined (__OMNIORB2__) || defined (__OMNIORB3__)
  } catch (CORBA::COMM_FAILURE& ex) {
        cerr << "Caught system exception COMM_FAILURE" << endl;
        exit(1);
#endif
  } catch (CosEventChannelAdmin::AlreadyConnected& ex) {
        cerr << "Pullh Consumer already connected !" << endl;
        exit(1);
  } catch (CORBA::BAD_PARAM& ex) {
        cerr << "BAD_PARAM Exception while connecting Pull Consumer !" << endl;
        exit (1);
  } catch (...) {
        cerr << "Caught exception" << endl;
        exit(1);
  }

  return 0;
}
