include ../trilib.mk

# EXAMPLE_LIB = $(BOTH_STATIC_LIB)

EXAMPLE_LIB = $(BOTH_LIB)
EXAMPLE_LIB_DEPEND = $(BOTH_LIB_DEPEND)

DIR_CPPFLAGS = $(CORBA_CPPFLAGS)
DIR_CPPFLAGS += $(COS_CPPFLAGS)

# omniidl/omniidl2 do not support long long and, hence, we need
# to pass the -DNOLONGLONG flag for TimeBase.idl.  In addition,
# we need to specify -WbBOA for omniORB3 since we still use BOA

# XXX (No idl to compile?)
# OMNIORB_IDL_ANY_FLAGS  += -DNOLONGLONG -WbBOA
# OMNIORB2_IDL_ANY_FLAGS += -DNOLONGLONG 

# add services/include
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/include,$(IMPORT_TREES))

CXXSRCS = \
  any_push_consumer.cc \
  any_push_supplier.cc \
  batch_pull_consumer.cc \
  batch_pull_supplier.cc \
  batch_push_consumer.cc \
  batch_push_supplier.cc \
  event_pull_consumer.cc \
  event_pull_supplier.cc \
  event_push_consumer.cc \
  event_push_supplier.cc \
  filter_struct_pull_consumer.cc \
  filter_struct_push_consumer.cc \
  filter_struct_push_supplier.cc \
  struct_pull_consumer.cc \
  struct_pull_supplier.cc \
  struct_push_consumer.cc \
  struct_push_supplier.cc

CXXOBJS = $(CXXSRCS:.cc=.o)

any_push_consumer   = $(patsubst %,$(BinPattern),any_push_consumer)
any_push_supplier   = $(patsubst %,$(BinPattern),any_push_supplier)
batch_pull_consumer = $(patsubst %,$(BinPattern),batch_pull_consumer)
batch_pull_supplier = $(patsubst %,$(BinPattern),batch_pull_supplier)
batch_push_consumer = $(patsubst %,$(BinPattern),batch_push_consumer)
batch_push_supplier = $(patsubst %,$(BinPattern),batch_push_supplier)
event_pull_consumer = $(patsubst %,$(BinPattern),event_pull_consumer)
event_pull_supplier = $(patsubst %,$(BinPattern),event_pull_supplier)
event_push_consumer = $(patsubst %,$(BinPattern),event_push_consumer)
event_push_supplier = $(patsubst %,$(BinPattern),event_push_supplier)
filter_struct_pull_consumer = $(patsubst %,$(BinPattern),filter_struct_pull_consumer)
filter_struct_push_consumer = $(patsubst %,$(BinPattern),filter_struct_push_consumer)
filter_struct_push_supplier = $(patsubst %,$(BinPattern),filter_struct_push_supplier)
struct_pull_consumer = $(patsubst %,$(BinPattern),struct_pull_consumer)
struct_pull_supplier = $(patsubst %,$(BinPattern),struct_pull_supplier)
struct_push_consumer = $(patsubst %,$(BinPattern),struct_push_consumer)
struct_push_supplier = $(patsubst %,$(BinPattern),struct_push_supplier)

TARGETS = \
  $(any_push_consumer)   \
  $(any_push_supplier)   \
  $(batch_pull_consumer) \
  $(batch_pull_supplier) \
  $(batch_push_consumer) \
  $(batch_push_supplier) \
  $(event_pull_consumer) \
  $(event_pull_supplier) \
  $(event_push_consumer) \
  $(event_push_supplier) \
  $(filter_struct_pull_consumer) \
  $(filter_struct_push_consumer) \
  $(filter_struct_push_supplier) \
  $(struct_pull_consumer) \
  $(struct_pull_supplier) \
  $(struct_push_consumer) \
  $(struct_push_supplier)

all:: $(TARGETS)

export:: $(TARGETS)
	@(module="omninfyexamples"; $(ExportExecutable))

clean::
	$(RM) $(TARGETS) *.d

$(notifd) : $(CXXOBJS) $(ALL_SERVER_HELPER_OBJS) $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))


$(any_push_consumer) : any_push_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(any_push_supplier) : any_push_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(batch_pull_consumer) : batch_pull_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(batch_pull_supplier) : batch_pull_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(batch_push_consumer) : batch_push_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(batch_push_supplier) : batch_push_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(event_pull_consumer) : event_pull_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(event_pull_supplier) : event_pull_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(event_push_consumer) : event_push_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(event_push_supplier) : event_push_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(filter_struct_pull_consumer) : filter_struct_pull_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(filter_struct_push_consumer) : filter_struct_push_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(filter_struct_push_supplier) : filter_struct_push_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(struct_pull_consumer) : struct_pull_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(struct_pull_supplier) : struct_pull_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(struct_push_consumer) : struct_push_consumer.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

$(struct_push_supplier) : struct_push_supplier.o $(EXAMPLE_LIB_DEPEND)
	@(libs="$(EXAMPLE_LIB)"; $(CXXExecutable))

