NFYLIB_CXXSRCS = \
    RDIDebug.cc        RDITime.cc         Filter_i.cc        FilterAdmin_i.cc \
    RDITypeMap.cc      RDI.cc             RDIFileSys.cc      RDIConfig.cc \
    RDIFileIO.cc       RDILog.cc          CosNaming_i.cc \
    RDIParser_y.cc     RDIParser_l.cc     RDIRVM.cc          RDIEval.cc \
    RDIStaticEval.cc   RDIDynamicEval.cc  RDIConstraint.cc   RDIOpSeq.cc  \
    ChannelAdmin_i.cc  PullConsumer_i.cc  PushConsumer_i.cc  EventChannel_i.cc \
    PullSupplier_i.cc  PushSupplier_i.cc  RDIChannelUtil.cc  RDIEventQueue.cc \
    CosEventProxy.cc   CosNotification.cc omniNotify.cc 

NFYLIB_CXXOBJS = $(NFYLIB_CXXSRCS:.cc=.o)

NFYLIB_CSRCS = RDIDummyAstError.c
NFYLIB_COBJS = RDIDummyAstError.o

NFYLIB_OBJS = $(NFYLIB_CXXOBJS) $(NFYLIB_COBJS)

# omniidl/omniidl2 do not support long long and, hence, we need
# to pass the -DNOLONGLONG flag for TimeBase.idl.  In addition,
# we need to specify -WbBOA for omniORB3 since we still use BOA

OMNIORB_IDL_ANY_FLAGS  += -DNOLONGLONG -WbBOA
OMNIORB2_IDL_ANY_FLAGS += -DNOLONGLONG 

# add services/include and services/omniNotify/include:
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/include,$(IMPORT_TREES))
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/omniNotify/include,$(IMPORT_TREES))

# can control -g option etc via <top>/mk/beforedir.mk
DIR_CPPFLAGS  = $(CORBA_CPPFLAGS)

CXXDEBUGFLAGS = -O2 -DNDEBUG

ifeq ($(platform),hppa_hpux_11.00)
CXXDEBUGFLAGS = +O1 -DNDEBUG
endif

# Uncomment this to build a debug version of omniNotify:
CXXDEBUGFLAGS = -g

# -mt does not belong in CFLAGS
CFLAGS := $(patsubst -mt,,$(CFLAGS))

ifndef COSDynamicBOACompatible

vpath %.idl $(IMPORT_TREES:%=%/idl/COS)
DIR_IDLFLAGS += -I. $(patsubst %,-I%/idl/COS,$(IMPORT_TREES))
DIR_IDLFLAGS  += -Wbuse_quotes
DIR_IDLFLAGS  += -DNOLONGLONG
DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -D_COS_LIBRARY 
DIR_IDLFLAGS += -WbBOA

NFYLIB_CXXSRCS += CosNotificationDynSK.cc TimeBaseDynSK.cc RDITestTypesDynSK.cc

%DynSK.cc: %.idl
	$(CORBA_IDL) $(DIR_IDLFLAGS) $^	

.PRECIOUS: %DynSK.cc

endif
