include ../trilib.mk

CXXSRCS = ReadyChannel_d.cc 
CXXOBJS = ReadyChannel_d.o  

# omniidl/omniidl2 do not support long long and, hence, we need
# to pass the -DNOLONGLONG flag for TimeBase.idl.  In addition,
# we need to specify -WbBOA for omniORB3 since we still use BOA

# XXX no idl to compile
# OMNIORB_IDL_ANY_FLAGS  += -DNOLONGLONG -WbBOA
# OMNIORB2_IDL_ANY_FLAGS += -DNOLONGLONG 

# add services/include
IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/include,$(IMPORT_TREES))

# XXX should not need to add services/omniNotify/include
# XXX to build a daemon (should just be another example application)

IMPORT_CPPFLAGS += $(patsubst %,-I%/src/services/omniNotify/include,$(IMPORT_TREES))

# can control -g option etc via <top>/mk/beforedir.mk
DIR_CPPFLAGS  = $(CORBA_CPPFLAGS)
DIR_CPPFLAGS += $(COS_CPPFLAGS)

notifd   = $(patsubst %,$(BinPattern),notifd)

all::     $(notifd)

export:: $(notifd)
	@(module="as"; $(ExportExecutable))

clean::
	$(RM) $(notifd) *.d

$(notifd) : $(CXXOBJS) $(TRI_LIB_DEPEND)
	@(libs="$(TRI_LIB)"; $(CXXExecutable))

# STATIC BUILD:
#$(notifd) : $(CXXOBJS) $(TRI_LIB_DEPEND)
#	@(libs="$(TRI_STATIC_LIB)"; $(CXXExecutable))

