// -*- Mode: C++; -*-
//                              File      : ReadyChannel_d.cc
//                              Package   : omniNotify-daemon
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of executable program omniNotify-daemon
//    and is distributed with the omniNotify release.
//
//    omniNotify-daemon is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//    USA.
//
// Description:
//    Implementation of the omniNotify daemon process
//
 
/*
$Log: ReadyChannel_d.cc,v $
Revision 1.48  2000/10/09 19:47:20  alcfp
modified version number

Revision 1.47  2000/09/27 19:30:10  alcfp
Stopped using tcAliasExpand=1 : dynamic evaluation now uses typecode equivalence test or DynFoo narrow test rather than checking for a specific TCKind

Revision 1.46  2000/08/22 18:21:47  alcfp
getopt fix

Revision 1.45  2000/08/16 20:18:50  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <sys/resource.h>
#include "CosNotifyChannelAdmin_i.h"
#include "omniNotify.h"

static notifyServer* on_server = 0;

// ----------------------------------------------------------//

void processUserInput(const char* prompt);

// ----------------------------------------------------------//

int main(int argc, char** argv)
{
  int indx=0, interactive=0;

  // Increase the limit of open file descriptor to the maximum
  struct rlimit rlp;
  if ( getrlimit(RLIMIT_NOFILE, &rlp) == 0 ) {
     rlp.rlim_cur = rlp.rlim_max;
     (void) setrlimit(RLIMIT_NOFILE, &rlp);
  }

  while ( indx < argc ) {
     if ( strcmp(argv[indx], "-i") == 0 ) {
	interactive = 1;
     } else if ( strcmp(argv[indx], "-h") == 0 ) {
	cout << "Usage: " << argv[0] << " [-i] [-h] [-v] [more]" << endl;
	cout << "   -i   : interactive mode"  << endl;
	cout << "   -h   : usage information" << endl;
	cout << "   -v   : software version"  << endl;
	cout << "   more : see omniNotify.h for a complete list" << endl;
	return 0;
     } else if ( strcmp(argv[indx], "-v") == 0 ) {
	cout << argv[0] << " -- omniNotify server version 1.0" << endl;
	return 0;
     }
     indx += 1;
  }

  // Configure the undelying ORB and BOA before creating a READY 
  // server instance

  WRAPPED_ORB_SETMAXTCP(32);
  //  WRAPPED_SET_TCALIASEXPAND(1);
  CORBA::ORB_ptr orb = WRAPPED_ORB_INIT(argc, argv);
  CORBA::BOA_ptr boa = WRAPPED_BOA_INIT(orb, argc, argv);
  WRAPPED_ORB_REGISTER_SERVANT_NAME(orb, "omniNotify_d");

  if ( ! (on_server = notifyServer::create(argc, argv, orb)) ) {
     cout << "Failed to create a new omniNotify instance" << endl;
     exit(-1);
  }

  if ( interactive ) {
     WRAPPED_IMPL_IS_READY_FORK(boa, "omniNotify_d");
     processUserInput(argv[0]);
  } else {
     WRAPPED_IMPL_IS_READY_BLOCK(boa, "omniNotify_d");
  }
  delete on_server;
  WRAPPED_ORB_BOA_CLEANUP(orb, boa);

  return 0;
}

// ----------------------------------------------------------//

void processUserInput(const char* prompt)
{
  CosNA_EventChannelFactory_ptr fact_ptr;
  CosNA_EventChannel_ptr chan_ptr;
  CosNA_ChannelIDSeq* cids = 0;
  char cmnd[1024];

  cout << endl << "\t\t-------------------------------" << 
          endl << "\t\tomniNotify Server Version 1.0" <<
	  endl << "\t\t AT&T Laboratories -- Research " << 
          endl << "\t\t-------------------------------" << endl << endl;
  while ( 1 ) {
     cout << prompt << ": " << flush;
     omni_thread::yield();
     if ( ! fgets(cmnd, 1024, stdin) )
	continue;
     cmnd[ strlen(cmnd) - 1 ] = '\0';    // Remove new line
     if ( strcasecmp(cmnd, "help") == 0 ) {
	cout << "\tTo terminate omniNotify enter:        exit | quit" << endl;
	cout << "\tTo show debugging information enter:  debug" << endl;
	cout << "\tTo show performance statistics enter: stats" << endl;
	cout << endl;
     } else if ( (strcasecmp(cmnd,"exit") == 0) ||
	         (strcasecmp(cmnd,"quit") == 0) ) {
	cout << prompt << ": shutting down ... please wait ..." << endl;
	break;
     } else if ( strcasecmp(cmnd, "stats") == 0 ) {
	fact_ptr = on_server->getChannelFactory();
	cids     = fact_ptr->get_all_channels();
   	for ( CORBA::ULong ix = 0; ix < cids->length(); ix++ ) {
	   chan_ptr = fact_ptr->get_event_channel( (*cids)[ix] );
	   if ( ! CORBA::is_nil(chan_ptr) ) {
	      AttNotifyChannelAdmin::EventChannel_var channel = 
			AttNotifyChannelAdmin::EventChannel::_narrow(chan_ptr);
	      if ( ! CORBA::is_nil(channel) ) 
	         channel->display_stats();	
	   }
	}
	delete cids; cids = 0;
	cout << endl;
     } else if ( strcasecmp(cmnd, "debug") == 0 ) {
	fact_ptr = on_server->getChannelFactory();
        cids     = fact_ptr->get_all_channels();
        for ( CORBA::ULong ix = 0; ix < cids->length(); ix++ ) {
           chan_ptr = fact_ptr->get_event_channel( (*cids)[ix] );
           if ( ! CORBA::is_nil(chan_ptr) ) {
	      AttNotifyChannelAdmin::EventChannel_var channel =
                        AttNotifyChannelAdmin::EventChannel::_narrow(chan_ptr);
              if ( ! CORBA::is_nil(channel) )
                 channel->display_state();        
           }
        }
        delete cids; cids = 0;
	cout << endl;
     } else if ( strlen(cmnd) >= 1) {
	cout << "Invalid command: " << cmnd << endl << endl;
	cout << "To terminate omniNotify enter:        exit | quit" << endl;
	cout << "To show debugging information enter:  debug" << endl;
        cout << "To show performance statistics enter: stats" << endl << endl;
     }
  }
}

