#!/usr/common/bin/perl

# ASSUMES: lex.yy.cc holds the output from flex (with -+ option)
#
# CREATES: RDIParser_l.cc with appropriate modifications.
#
# DELETES: lex.yy.cc
#
# 
# The mods:
#   (1) remove this line:
#                #include <unistd.h>
#
#   (2) change
#                #include <FlexLexer.h>
#       to
#                #include "ModFlexLexer.h"
#   (3) following
#                YY_DECL {
#       (which may span 2 lines), add:
#                #ifdef YYLEX_USER_INIT
#                     YYLEX_USER_INIT
#                #endif
#
#   (4) add comment about DEC C++ for OpenVMS needing a final #line directive,
#       followed by an appropriate #line directive

open (LEXGEN, "<lex.yy.cc") or die "Could not open lex.yy.cc: $!";
open (OUTFILE, ">RDIParser_l.cc") or die "Could not open RDIParser_l.cc: $!";

$outlines = 0;
$declstart = 0;

print OUTFILE "// -*- Mode: C++; -*-\n"; $outlines++;
print OUTFILE "\n"; $outlines++;
print OUTFILE "//                              File      : RDIParser_l.cc\n"; $outlines++;
print OUTFILE "//                              Package   : omniNotify-Library\n"; $outlines++;
print OUTFILE "//                              Created on: 1-jan-1998\n"; $outlines++;
print OUTFILE "//                              Authors   : gruber&panagos\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "//    Copyright (C) 1998-2000 AT&T Laboratories -- Research\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "//    This file is part of the omniNotify library\n"; $outlines++;
print OUTFILE "//    and is distributed with the omniNotify release.\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "//    The omniNotify library is free software; you can redistribute it and/or\n"; $outlines++;
print OUTFILE "//    modify it under the terms of the GNU Library General Public\n"; $outlines++;
print OUTFILE "//    License as published by the Free Software Foundation; either\n"; $outlines++;
print OUTFILE "//    version 2 of the License, or (at your option) any later version.\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "//    This library is distributed in the hope that it will be useful,\n"; $outlines++;
print OUTFILE "//    but WITHOUT ANY WARRANTY; without even the implied warranty of\n"; $outlines++;
print OUTFILE "//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"; $outlines++;
print OUTFILE "//    Library General Public License for more details.\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "//    You should have received a copy of the GNU Library General Public\n"; $outlines++;
print OUTFILE "//    License along with this library; if not, write to the Free\n"; $outlines++;
print OUTFILE "//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA\n"; $outlines++;
print OUTFILE "//    02111-1307, USA\n"; $outlines++;
print OUTFILE "//\n"; $outlines++;
print OUTFILE "// -------------------------------------------------------------------\n";  $outlines++;
print OUTFILE "// ** This file automatically generated by running buildgens.sh in    \n";  $outlines++;
print OUTFILE "//    <top>/src/services/omniNotify/lib  Rebuild at your own risk!    \n";  $outlines++;
print OUTFILE "// -------------------------------------------------------------------\n";  $outlines++;
print OUTFILE "\n"; $outlines++;

while (<LEXGEN>) {
  chop;
  if (/^\#include\s+\<unistd.h\>/) {
    # skip
    $declstart = 0;
  } elsif (/^\#include\s+\<FlexLexer.h\>/) {
    print OUTFILE "#include \"ModFlexLexer.h\"\n"; $outlines++;
    $declstart = 0;
  } elsif (/^\s*YY_DECL\s*\{/) {
    print OUTFILE $_ . "\n"; $outlines++;
    print OUTFILE "#ifdef YYLEX_USER_INIT\n"; $outlines++;
    print OUTFILE "\tYYLEX_USER_INIT\n"; $outlines++;
    print OUTFILE "#endif\n"; $outlines++;
    $declstart = 0;
  } elsif (/^\s*YY_DECL\s*$/) {
    print OUTFILE $_ . "\n"; $outlines++;
    $declstart = 1;
  } elsif ($declstart == 1 && /^\s*\{/) {
    print OUTFILE $_ . "\n"; $outlines++;
    print OUTFILE "#ifdef YYLEX_USER_INIT\n"; $outlines++;
    print OUTFILE "\tYYLEX_USER_INIT\n"; $outlines++;
    print OUTFILE "#endif\n"; $outlines++;
    $declstart = 0;
  } else {
    print OUTFILE $_ . "\n"; $outlines++;
    $declstart = 0;
  }
}

print OUTFILE "#ifdef __VMS\n"; $outlines++;
print OUTFILE "// Some versions of DEC C++ for OpenVMS set the module name used by the\n"; $outlines++;
print OUTFILE "// librarian based on the last #line encountered.\n"; $outlines++;
$outlines++; # fencepost
print OUTFILE "#line $outlines \"RDIParser_l.cc\"\n";
print OUTFILE "#endif\n\n";

close (LEXGEN);
close (OUTFILE);

unlink 'lex.yy.cc';
