// -*- Mode: C++; -*-
//                              File      : RDIConfig.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDIConfig.h,v $
Revision 1.5  2000/08/22 18:23:48  alcfp
added description to each file

Revision 1.4  2000/08/16 20:19:06  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef _RDI_CONFIG_H_
#define _RDI_CONFIG_H_

#include <iostream.h>

// --------------------------------------------------------------- //
// Generic class for parsing command line arguments and/or reading //
// configuration parameters from files.  The format of the command //
// line arguments is: -Dparam_name=param_value -- no spaces should //
// be used.  The configuration file  contains entries of the form: //
// param_name param_value. Tabs and spaces can be used to separate //
// names from values and lines starting with '#' are considered to //
// be comments and are ignored.  Finally, enviroment variables can //
// be used and their values are used when loading form a file.     //
//                                                                 //
// NOTE: using -DCONFIGFILE=name as a command line argument forces //
//       the loading of configuration parameters from file 'name'. //
//       Parameters that have been set already, will be updated by //
//       using the values found in the file, if any.               //
// --------------------------------------------------------------- //

class RDI_Config {
public:
  RDI_Config();
  ~RDI_Config();

  // Parse command line arguments and extract configuration
  // parameters. If 'rm_args' is set, 'argc' and 'argv' are
  // updated to reflect the removal of these parameters.

  int parse_arguments(int& argc, char** argv, unsigned char rm_args=0);

  // Import/Export configuration parameters from/to a file

  int import_settings(const char* fname);
  int export_settings(const char* fname=0, const char* header=0) const;

  // Retrieve the value of a configuration parameter. When
  // the parameter does not exist or the value type is not
  // the same as the one requested, -1 is returned.

  int get_value(const char* pname, char*&  value) const;
  int get_value(const char* pname, int&    value) const;
  int get_value(const char* pname, long&   value) const;
  int get_value(const char* pname, double& value) const;

  // Retrieve the value of a configuration parameter. When
  // the parameter does not exist, it is created using the
  // provided default value.  On error, -1 is returned.

  int getset_value(const char* pname, char*&  value, const char* dfval);
  int getset_value(const char* pname, int&    value, int         dfval);
  int getset_value(const char* pname, long&   value, long        dfval);
  int getset_value(const char* pname, double& value, double      dfval);

  // Change the value of/create a configuration parameter.
  // In case of an error, -1 is returned

  int set_value(const char* pname, const char* value);

  // Change the value of a configuration parameter by using
  // the corresponding environment variable, if defined. If
  // no name is given, update the existing parameters using
  // their corresponding environment variables, if defined.

  int env_update(const char* pname=0);

  friend ostream& operator << (ostream& out, const RDI_Config& cfg);

private:
  enum { HASH_SIZE = 32, HASH_MASK = HASH_SIZE - 1 };
  struct node_t {
	char *_name, *_value; node_t* _next;
	node_t() : _name(0), _value(0), _next(0) {;}
	~node_t()  { if ( _name )  delete [] _name;  _name  = 0;
		     if ( _value ) delete [] _value; _value = 0; }
  };
  node_t* _htbl[ HASH_SIZE ];
};

#endif
