// -*- Mode: C++; -*-
//                              File      : CosEventChannelAdmin_i.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//     set of C++ definitions for the CosEventChanneAdmin module
//
 
/*
$Log: CosEventChannelAdmin_i.h,v $
Revision 1.16  2000/10/01 13:29:09  alcfp
Removed sleep() calls used for synchronization with unbound threads. Counters and flags are used instead

Revision 1.15.2.1  2000/09/30 15:39:50  alcfp
Removed sleep() calls used for synchronization with unbound threads. Counters and flags are used instead

Revision 1.15  2000/08/22 18:23:47  alcfp
added description to each file

Revision 1.14  2000/08/16 20:18:54  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef _COS_EVENT_CHANNEL_ADMIN_I_H_
#define _COS_EVENT_CHANNEL_ADMIN_I_H_

#include "corba_wrappers.h"
#include "RDIEvent.h"
#include "RDIChannelUtil.h"
#include "COS/BOA/CosEventComm.hh"
#include "COS/BOA/CosEventChannelAdmin.hh"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= //
// While the Notification Service can be used to offer the functionality //
// of the Event Service,  we need to implement the Proxy objects for the //
// Event Service in order to have full backward compatibility.           //
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= //

class EventProxyPushConsumer_i : 
	WRAPPED_SKELETON_SUPER(CosEventChannelAdmin::, ProxyPushConsumer) {
  friend class SupplierAdmin_i;
public:
  EventProxyPushConsumer_i(SupplierAdmin_i* admin, EventChannel_i* channel);

  // Methods from CosEventComm::PushConsumer Interface
  void push(const CORBA::Any& data  WRAPPED_DECLARG );
  void disconnect_push_consumer( WRAPPED_DECLARG_VOID );

  // Methods from CosEventChannelAdmin::ProxyPushConsumer Interface
  void connect_push_supplier(CosEventComm::PushSupplier_ptr supplier  
			     WRAPPED_DECLARG );

  // (Local only -- not available via RPC)
  void disconnect_client_and_dispose();
  friend ostream& operator<<(ostream& out,const EventProxyPushConsumer_i& prx);
private:
  omni_mutex       _oplock;
  EventChannel_i*  _channel;
  SupplierAdmin_i* _myadmin;
  CORBA::ULong     _nevents;
  RDI_ProxyState   _pxstate;
  CosEventComm::PushSupplier_var _supplier;
};

class EventProxyPullConsumer_i : 
	public virtual RDIProxyPullConsumer, 
	WRAPPED_SKELETON_SUPER(CosEventChannelAdmin::, ProxyPullConsumer) {
  friend class SupplierAdmin_i;
public:
  EventProxyPullConsumer_i(SupplierAdmin_i* admin, EventChannel_i* channel);

  // Methods from CosEventComm::PullConsumer Interface
  void disconnect_pull_consumer( WRAPPED_DECLARG_VOID );

  // Methods from CosEventChannelAdmin::ProxyPullConsumer Interface
  void connect_pull_supplier(CosEventComm::PullSupplier_ptr supplier
			     WRAPPED_DECLARG );

  // (Local only -- not available via RPC)
  const RDI_TimeValue& last_pull_tms() const	{ return _pulltms; }
  void pull_event(CORBA::Boolean& invalid);
  void disconnect_client_and_dispose();
  friend ostream& operator<<(ostream& out,const EventProxyPullConsumer_i& prx);
private:
  omni_mutex       _oplock;
  EventChannel_i*  _channel;
  SupplierAdmin_i* _myadmin;
  omni_thread*     _pworker;
  omni_condition*  _iamdone;
  CORBA::Boolean   _thrdone;	// true when worker thread exits
  CORBA::ULong     _nevents;
  RDI_ProxyState   _pxstate;
  RDI_TimeValue    _pulltms;    // Timestamp of last pull
  CosEventComm::PullSupplier_var _supplier;

  void _pull();
};

class EventProxyPushSupplier_i : 
	public virtual RDIProxyPushSupplier, 
	WRAPPED_SKELETON_SUPER(CosEventChannelAdmin::, ProxyPushSupplier) {
public:
  EventProxyPushSupplier_i(ConsumerAdmin_i* admin, EventChannel_i* channel);

  // Methods from CosEventChannelAdmin::ProxyPushSupplier Interface
  void connect_push_consumer(CosEventComm::PushConsumer_ptr consumer
			     WRAPPED_DECLARG );

  // Methods from CosEventComm::PushSupplier Interface
  void disconnect_push_supplier( WRAPPED_DECLARG_VOID );

  // (Local only -- not available via RPC)
  void add_event(RDI_StructuredEvent* event);
  void push_event(CORBA::Boolean& invalid);
  void disconnect_client_and_dispose();
  CORBA::Boolean has_events() const     { return _ntfqueue.length() ? 1 : 0; }
  friend ostream& operator<<(ostream& out,const EventProxyPushSupplier_i& prx);
private:
  omni_mutex       _oplock;
  EventChannel_i*  _channel;
  ConsumerAdmin_i* _myadmin;
  omni_thread*     _pworker;
  omni_condition*  _iamdone;
  CORBA::Boolean   _thrdone;	// true when worker thread exits
  CORBA::ULong     _nevents;
  RDI_ProxyState   _pxstate;
  CosEventComm::PushConsumer_var _consumer;
  RDI_List<RDI_StructuredEvent *> _ntfqueue;

  void _push();
};

class EventProxyPullSupplier_i : 
	WRAPPED_SKELETON_SUPER(CosEventChannelAdmin::, ProxyPullSupplier) {
public:
  EventProxyPullSupplier_i(ConsumerAdmin_i* admin, EventChannel_i* channel);

  // Methods from CosEventChannelAdmin::ProxyPullSupplier
  void  connect_pull_consumer(CosEventComm::PullConsumer_ptr consumer
			      WRAPPED_DECLARG );

  // Methods from CosEventComm::PullSupplier
  CORBA::Any* pull( WRAPPED_DECLARG_VOID );
  CORBA::Any* try_pull(CORBA::Boolean& has_event WRAPPED_DECLARG );
  void        disconnect_pull_supplier( WRAPPED_DECLARG_VOID );

  // (Local only -- not available via RPC)
  void add_event(RDI_StructuredEvent* event);
  void disconnect_client_and_dispose();
  friend ostream& operator<<(ostream& out,const EventProxyPullSupplier_i& prx);
private:
  omni_mutex       _oplock;
  omni_condition   _isempty;
  EventChannel_i*  _channel;
  ConsumerAdmin_i* _myadmin;
  CORBA::ULong     _blkpull;	// # blocked pull threads
  CORBA::ULong     _nevents;
  RDI_ProxyState   _pxstate;
  CosEventComm::PullConsumer_var _consumer;
  RDI_List<RDI_StructuredEvent *> _ntfqueue;
};

#endif
