// This application implements a push supplier that is connected
// to a PUSH_STRUCTURED proxy.
// It generates CosNotification::StructuredEvent events that have
// Stock::Ticker event type, 5 filterable_data fields, and a
// CORBA::ULong stored in the remainder_of_body field.
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>

#include "corba_wrappers.h"


#include "CosNotify.h"

#include "CosNotifyComm_i.h"

static void usage(const char* pname)
{
   cout << "Usage: " << pname << " [-d numb] [-n name] [-v]" << endl;
   cout << "       -d numb : disconnect after numb pushes" << endl;
   cout << "       -n name : channel name [\"EventChannel\"]" << endl;
   cout << "       -v      : verbose -- output progress data" << endl;
}

int main(int argc, char** argv)
{
  CosNA_StructuredProxyPushConsumer_var prxc;
  CosNA_EventChannel_var channel;
  CosN_StructuredEvent sevnt;
  StructuredPushSupplier_i* supplier=0;
  CORBA::Boolean verbose=0;
  char *channelName = (char *) "EventChannel";
  unsigned int numEvent=0;
  int c, i;

  // Parse command line arguments and initialize global variables

  while ( (c = getopt(argc, argv,"d:n:v")) != EOF ) {
        switch (c) {
        case 'd': numEvent = (unsigned int) atoi(optarg);
                  break;
        case 'n': channelName = optarg;
                  break;
        case 'v': verbose = 1;
                  break;
        default : usage(argv[0]);
                  exit(-1);
     }
  }

  CORBA::ORB_var orb = WRAPPED_ORB_INIT(argc, argv);
  CORBA::BOA_var boa = WRAPPED_BOA_INIT(orb, argc, argv);

  if ( ! (supplier = new StructuredPushSupplier_i()) ) {
	cerr << "Failed to create structured supplier object" << endl;
	exit(-1);
  }
  WRAPPED_ORB_REGISTER_SERVANT_NAME(orb, "struct_push_supplier");
  WRAPPED_BOA_OBJ_IS_READY(boa, supplier);

  try {
	CosNaming::Name                          name;
        CORBA::Object_var                        echannel_ref;
        CORBA::Object_var                        name_service;
        CosNaming::NamingContext_var             name_context;
        CosNA_AdminID           saID;
        CosNA_ProxyID           pxID;
        CosNA_SupplierAdmin_var sadmin;
	CosNF_ConstraintExpSeq        constr;
	CosNF_FilterFactory_var       flfact;
	CosNF_Filter_var              filter;

	if ( verbose ) 
                cout << "Resolving reference to: 'NameService'" << endl;
	name_service = WRAPPED_RESOLVE_INITIAL_REFERENCES(orb, "NameService"); 
        name_context = CosNaming::NamingContext::_narrow(name_service);
        if ( CORBA::is_nil(name_context) ) {
                cerr << "Failed to obtain context for NameService" << endl;
                exit(1);
        }
        name.length(1);
        name[0].id   = CORBA::string_dup(channelName);
        name[0].kind = CORBA::string_dup(channelName);
        if ( verbose ) 
                cout << "Resolving reference to: '"<<channelName<<"'" << endl;
        echannel_ref = name_context->resolve(name);
        channel = CosNA_EventChannel::_narrow(echannel_ref);
        if ( CORBA::is_nil(channel) ) {
                cerr << "Failed to narrow Event Channel !" << endl;
                exit(1);
        }
        if ( verbose ) 
                cout << "Releasing reference to: 'NameService'" << endl;
        if ( verbose ) 
                cout << "Creating new SupplierAdmin object" << endl;
        sadmin = channel->new_for_suppliers(CosNA_AND_OP,saID);
        if ( CORBA::is_nil(sadmin) ) {
                cerr << "Failed to create SupplierAdmin object!" << endl;
                exit(1);
        }
        if ( verbose ) 
                cout << "Created SupplierAdmin with ID " << saID << endl;

        CosNA_ProxyConsumer_var cons;
        if ( verbose )
                cout << "Creating proxy for StructuredConsumer" << endl;
        cons=sadmin->obtain_notification_push_consumer(
                                CosNA_STRUCTURED_EVENT, pxID);
        prxc=CosNA_StructuredProxyPushConsumer::_narrow(cons);
        if ( CORBA::is_nil(prxc) ) {
                cerr << "Failed to find Proxy Consumer !" << endl;
                exit(1);
        }
        if ( verbose ) {
                cout << "Created proxy with ID " << pxID << endl;
                cout << "Register with BOA to receive requests" << endl;
        }

        if ( verbose )
                cout << "Connecting consumer object to proxy" << endl;
        prxc->connect_structured_push_supplier(supplier->_this());
        if ( verbose )
                cout << "Informing channel about supplied event types" << endl;

  	sevnt.header.fixed_header.event_type.domain_name = 
					CORBA::string_dup("Stock");
  	sevnt.header.fixed_header.event_type.type_name   = 
					CORBA::string_dup("Ticker");
  	sevnt.header.variable_header.length( 0 );
  	sevnt.filterable_data.length(5);
  	sevnt.filterable_data[0].name = (const char*) "Field 0";
  	sevnt.filterable_data[0].value <<= (CORBA::Long) 0;
  	sevnt.filterable_data[1].name = (const char*) "Field 1";
  	sevnt.filterable_data[1].value <<= (CORBA::Long) 1;
  	sevnt.filterable_data[2].name = (const char*) "Field 2";
  	sevnt.filterable_data[2].value <<= (CORBA::Long) 2;
  	sevnt.filterable_data[3].name = (const char*) "Field 3";
  	sevnt.filterable_data[3].value <<= (CORBA::Long) 3;
  	sevnt.filterable_data[4].name = (const char*) "Priority";

	for (i=0; i < (int)numEvent; i++) {
		sevnt.filterable_data[4].value <<= (CORBA::Long) i;
		sevnt.remainder_of_body <<= (CORBA::ULong) i;
		prxc->push_structured_event(sevnt);
		if ( verbose )
			cout << "Pushed structured event: " << i << endl;
	}
	if ( verbose )
                cout << "Disconnecting supplier from channel" << endl;
        prxc->disconnect_structured_push_consumer();
	if ( verbose )
                cout << "Destroying the supplier admin object" << endl;
        sadmin->destroy();
        WRAPPED_DISPOSE_IMPL(supplier);
 
  } catch (CORBA::ORB::InvalidName& ex) {
        cerr << "Service required is invalid [does not exist]" << endl;
        return -1;
#if defined (__OMNIORB2__) || defined (__OMNIORB3__)
  } catch (CORBA::COMM_FAILURE& ex) {
        cerr << "Caught system exception COMM_FAILURE" << endl;
        return -1;
#endif
  } catch (CosEventChannelAdmin::AlreadyConnected& ex) {
        cerr << "Push Supplier already connected!" << endl;
        return -1;
  } catch (CORBA::BAD_PARAM& ex) {
        cerr << "BAD_PARAM Exception while connecting Push Supplier!" << endl;
        return -1;
  } catch (...) {
        cerr << "Caught exception while interacting with channel" << endl;
        return -1;
  }
  return 0;
}
