// -*- Mode: C++; -*-
//                              File      : omniNotify.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    the entry point to the omniNotify library
//
 
/*
$Log: omniNotify.h,v $
Revision 1.5  2000/10/04 02:40:05  alcfp
small fixes to avoid some compiler warnings

Revision 1.4  2000/08/22 18:23:52  alcfp
added description to each file

Revision 1.3  2000/08/16 20:19:20  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __OMNI_NOTIFY_H__
#define __OMNI_NOTIFY_H__

#include "COS/BOA/CosNotifyChannelAdmin.hh"

// ------------------------------------------------------------- //
// The following class exposes the functionality provided by the //
// omniNotify library,  i.e., creation of an EventChannelFactory //
// and a default EventChannel.                                   //
// ------------------------------------------------------------- //

typedef CosNotifyChannelAdmin::EventChannelFactory_ptr	
	CosNA_EventChannelFactory_ptr;

class notifyServer {
public:
  notifyServer();
  virtual ~notifyServer()	{;}

  // Create a notifyServer instance. This instance will create its
  // own channel factory and default channel objects, based on the
  // provided command line arguments -- ORB must have been already
  // initialized. These objects are named 'ChannelFactory' and 
  // 'EventChannel', respectively, and are registered with the
  // default NameService.  The command line arguments supported by
  // the current implementation are:
  // 
  //	-n      : do NOT register the event channel factory and 
  //              event channel with the NameService 
  //    -c name : use the configuration file 'name'
  // 
  // In addition to the above switches, omniNotify understands the
  // following command line argument format 
  // 
  //    -Dparam_name=param_value
  // 
  // Here, 'param_name' must be a valid parameter name.  A list of
  // valid names can be found in 'channel.cfg', a configuration
  // file provided with the distribution.

  static notifyServer* create(int argc, char** argv, CORBA::ORB_ptr orb);

  // Given an omniNotify object, one can retrieve the event channel 
  // factory and then iterate over all channels created by it. Note
  // that each channel is an AttNotifyChannelAdmin::EventChannel

  CosNA_EventChannelFactory_ptr getChannelFactory() const;

protected:
  CosNA_EventChannelFactory_ptr _factory;

  notifyServer(const notifyServer&);
  notifyServer& operator = (const notifyServer&);
};

#endif
