// -*- Mode: C++; -*-
//                              File      : RDITypeMap.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDITypeMap.h,v $
Revision 1.10  2000/08/22 18:23:52  alcfp
added description to each file

Revision 1.9  2000/08/16 20:19:20  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef _RDI_TYPE_MAP_H_
#define _RDI_TYPE_MAP_H_

#include <iostream.h>
#include "RDIMutex.h"
#include "RDIHash.h"
#include "CosNotify.h"
#include "CosNotifyFilter_i.h"
#include "CosNotifyChannelAdmin_i.h"

/** RDI_TypeMap
  *
  * This object is responsible for maintaining the mapping between
  * filters, which are registered with ConsumerAdmin/ProxySupplier
  * objects, and the event types present in the constraints of the
  * filters.
  */

class RDI_TypeMap {
public:
  // Support data structures required for implementing the mapping

  struct FNode_t {
	Filter_i* _fltr;
	FNode_t*  _next;
	FNode_t(Filter_i* fltr=0) : _fltr(fltr), _next(0) {;}
  };

  struct FList_t {
	FNode_t* _star_star;
	FNode_t* _domn_star;
	FNode_t* _star_type;
	FNode_t* _domn_type;
	FList_t() : _star_star(0),_domn_star(0),_star_type(0),_domn_type(0) {;}
  };

  RDI_TypeMap(EventChannel_i* channel, unsigned int init_hash_size=128);
  ~RDI_TypeMap();

  bool update(const CosN_EventTypeSeq& added,
	      const CosN_EventTypeSeq& deled,
	      ConsumerAdmin_i* admin, Filter_i* filter);
  bool update(const CosN_EventTypeSeq& added,
	      const CosN_EventTypeSeq& deled,
	      RDI_DummyProxy_i* proxy, Filter_i* filter);

  // Locate all filters for a given event type and a ConsumerAdmin
  // or ProxySupplier object -- returning a consistent snapshot of
  // all filters is achieved by either using locking or creating a
  // separate copy.  We chose locking and, hence,  the caller MUST
  // call 'lookup_end' when done with the filters.

  void lookup_begin(const char* domain_name, const char* type_name, 
		    ConsumerAdmin_i* admin, FList_t& filters);
  void lookup_begin(const CosN_EventType& type, 
		    ConsumerAdmin_i* admin, FList_t& filters); 
  void lookup_begin(const char* domain_name, const char* type_name,
		    RDI_DummyProxy_i* proxy, FList_t& filters);
  void lookup_begin(const CosN_EventType& type, 
		    RDI_DummyProxy_i* proxy, FList_t& filters);
  void lookup_end()	{ _lock.unlock(); }

  // Retrieve the list of all event types registered with the map

  CosN_EventTypeSeq* obtain_subscription_types();

  // The following member function is provided for debugging

  void debug(ostream& out = cout);

public:
  struct ANode_t {
        ConsumerAdmin_i* _admn;
        FNode_t*         _fltr;
        ANode_t*         _next;
	ANode_t(ConsumerAdmin_i* admn=0, FNode_t* fltr=0) :
				_admn(admn), _fltr(fltr), _next(0) {;}
  };
  struct PNode_t {
        RDI_DummyProxy_i* _prxy;
        FNode_t*          _fltr;
        PNode_t*          _next;
	PNode_t(RDI_DummyProxy_i* prxy=0, FNode_t* fltr=0) :
				_prxy(prxy), _fltr(fltr), _next(0) {;}
  };
  struct VNode_t {
	ANode_t* _admn;
	PNode_t* _prxy;
	VNode_t(ANode_t* admn=0, PNode_t* prxy=0) : 
				_admn(admn), _prxy(prxy) {;}
  };
private:
  RDI_RWMutex _lock;
  EventChannel_i* _channel;
  RDI_Hash<CosN_EventType, VNode_t> _tmap;
};

#endif
