// -*- Mode: C++; -*-
//                              File      : RDIOstreamUtils.h
//                              Package   : omniNotify-Library
//                              Created on: 1-Jan-1998
//                              Authors   : gruber&panagos
//
//    Copyright (C) 1998-2000 AT&T Laboratories -- Research
//
//    This file is part of the omniNotify library
//    and is distributed with the omniNotify release.
//
//    The omniNotify library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
//    02111-1307, USA
//
//
// Description:
//    proprietary interface
//
 
/*
$Log: RDIOstreamUtils.h,v $
Revision 1.17  2000/10/04 02:40:04  alcfp
small fixes to avoid some compiler warnings

Revision 1.16  2000/09/27 19:30:11  alcfp
Stopped using tcAliasExpand=1 : dynamic evaluation now uses typecode equivalence test or DynFoo narrow test rather than checking for a specific TCKind

Revision 1.15  2000/08/22 18:23:51  alcfp
added description to each file

Revision 1.14  2000/08/16 20:19:18  alcfp
Added licensing notice to each .h and .cc file where library files get GLPL notice and daemon file gets GPL notice -- examples do not claim any license but point out that the library and daemon code does have a license notice

*/
 
#ifndef __rdi_ostream_utils_h__
#define __rdi_ostream_utils_h__

#include "CosNotify.h"
#include "RDIEvalDefs.h"
#include "RDIDynamicEvalDefs.h"

////////////////////////////////////
// useful ostream ops

inline
ostream& operator<< (ostream& out, const CosN_QoSError_code & ecode) {
  switch (ecode) {
  case CosN_UNSUPPORTED_PROPERTY:  return out << "UNSUPPORTED_PROPERTY";
  case CosN_UNAVAILABLE_PROPERTY:  return out << "UNAVAILABLE_PROPERTY";
  case CosN_UNSUPPORTED_VALUE:     return out << "UNSUPPORTED_VALUE";
  case CosN_UNAVAILABLE_VALUE:     return out << "UNAVAILABLE_VALUE";
  case CosN_BAD_PROPERTY:          return out << "BAD_PROPERTY";
  case CosN_BAD_TYPE:              return out << "BAD_TYPE";
  case CosN_BAD_VALUE:             return out << "BAD_VALUE";
  }
  return out << "(XXX unexpected CosN_QoSError_code)" << (unsigned long)ecode;
}

inline
ostream& operator<< (ostream& out, const CosNA_ProxyType & ptype) {
  switch (ptype) {
  case CosNA_PUSH_ANY:             return out << "PUSH_STRUCTURED";
  case CosNA_PULL_ANY:             return out << "PULL_ANY";
  case CosNA_PUSH_STRUCTURED:      return out << "PUSH_STRUCTURED";
  case CosNA_PULL_STRUCTURED:      return out << "PULL_STRUCTURED";
  case CosNA_PUSH_SEQUENCE:        return out << "PUSH_SEQUENCE";
  case CosNA_PULL_SEQUENCE:        return out << "PULL_SEQUENCE";
  case CosNA_PUSH_TYPED:           return out << "PUSH_TYPED";
  case CosNA_PULL_TYPED:           return out << "PULL_TYPED";
  }
  return out << "(XXX unexpected CosNA_ProxyType)" << (unsigned long)ptype;
}

inline
ostream& operator<< (ostream& out, const CosNA_ObtainInfoMode & infomode) {
  switch (infomode) {
  case CosNA_ALL_NOW_UPDATES_OFF:  return out << "ALL_NOW_UPDATES_OFF";
  case CosNA_ALL_NOW_UPDATES_ON:   return out << "ALL_NOW_UPDATES_ON";
  case CosNA_NONE_NOW_UPDATES_OFF: return out << "NONE_NOW_UPDATES_OFF";
  case CosNA_NONE_NOW_UPDATES_ON:  return out << "NONE_NOW_UPDATES_ON";
  }
  return out << "(XXX unexpected CosNA_ObtainInfoMode)" << (unsigned long)infomode;
}

inline
ostream& operator<< (ostream& out, const CosNA_ClientType & ctype) {
  switch (ctype) {
  case CosNA_ANY_EVENT:            return out << "ANY_EVENT";
  case CosNA_STRUCTURED_EVENT:     return out << "STRUCTURED_EVENT";
  case CosNA_SEQUENCE_EVENT:       return out << "SEQUENCE_EVENT";
  }
  return out << "(XXX unexpected CosNA_ClientType)" << (unsigned long)ctype;
}

inline
ostream& operator<< (ostream& out, const CosNA_InterFilterGroupOperator & ifilterop) {
  switch (ifilterop) {
  case CosNA_AND_OP:               return out << "AND_OP";
  case CosNA_OR_OP:                return out << "OR_OP";
  }
  return out << "(XXX unexpected CosNA_InterFilterGroupOperator)" << (unsigned long)ifilterop;
}

inline
ostream& operator<< (ostream& out, const CosN_EventType & t) {
  if ((! t.domain_name) && (! t.type_name))
    return out << "<NULL_STRING>::<NULL_STRING>";
  if (! t.domain_name)
    return out << "<NULL_STRING>::" << t.type_name;
  if (! t.type_name)
    return out << t.domain_name << "::<NULL_STRING>";
  return out << t.domain_name << "::" << t.type_name;
}

inline
ostream& operator<< (ostream& out, const CosN_EventTypeSeq & seq) {
  out << "EventTypeSeq:{ ";
  for (unsigned int i = 0; i < seq.length(); i++) {
    if (i>0) out << ", ";
    out << seq[i];
  }
  return out << " }";
}

// XXX this assumes there is no CORBA::longlong type
inline
ostream& operator<< (ostream& out, const RDI_RelTime& rtm) {
  return out << "RelTime[" << " low:" << rtm.low << " high:" << rtm.high << "]";
}

inline
ostream& operator<< (ostream& out, const RDI_AbsTime& atm) {
  return out << "AbsTime[ time:" << atm.time << "  inacclo:" << atm.inacclo << " inacchi:" << atm.inacchi << " tdf:" << atm.tdf << "]";
}

inline
ostream& operator<< (ostream& out, const CORBA::TCKind& tckind) {
  switch (tckind) {
  case CORBA::tk_null:           return out << "null";
  case CORBA::tk_void:           return out << "void";
  case CORBA::tk_short:          return out << "short";
  case CORBA::tk_long:           return out << "long";
  case CORBA::tk_ushort:         return out << "ushort";
  case CORBA::tk_ulong:          return out << "ulong";
  case CORBA::tk_float:          return out << "float";
  case CORBA::tk_double:         return out << "double";
  case CORBA::tk_boolean:        return out << "bool";
  case CORBA::tk_char:           return out << "char";
  case CORBA::tk_octet:          return out << "octet";
  case CORBA::tk_any:            return out << "any";
  case CORBA::tk_TypeCode:       return out << "TypeCode";
  case CORBA::tk_Principal:      return out << "Principle";
  case CORBA::tk_objref:         return out << "objref";
  case CORBA::tk_struct:         return out << "struct";
  case CORBA::tk_union:          return out << "union";
  case CORBA::tk_enum:           return out << "enum";
  case CORBA::tk_string:         return out << "string";
  case CORBA::tk_sequence:       return out << "sequence";
  case CORBA::tk_array:          return out << "array";
  case CORBA::tk_alias:          return out << "alias";
  case CORBA::tk_except:         return out << "except";
  case CORBA::tk_longlong:       return out << "longlong";
  case CORBA::tk_ulonglong:      return out << "ulonglong";
  case CORBA::tk_longdouble:     return out << "longdouble";
  }
  return out << "(XXX unexpected CORBA::TCKind)" << (unsigned long)tckind;
}


inline
ostream& operator<< (ostream& out, const RDI_RTValKind& tckind) {
  switch (tckind) {
  case RDI_rtk_null:           return out << "null";
  case RDI_rtk_void:           return out << "void";
  case RDI_rtk_weak_long:      return out << "weak_long";
  case RDI_rtk_short:          return out << "short";
  case RDI_rtk_ushort:         return out << "ushort";
  case RDI_rtk_long:           return out << "long";
  case RDI_rtk_ulong:          return out << "ulong";
  case RDI_rtk_float:          return out << "float";
  case RDI_rtk_double:         return out << "double";
  case RDI_rtk_boolean:        return out << "bool";
  case RDI_rtk_char:           return out << "char";
  case RDI_rtk_octet:          return out << "octet";
  case RDI_rtk_enum_ident:     return out << "enum_id";
  case RDI_rtk_enum_val:       return out << "enum_val";
  case RDI_rtk_string:         return out << "string";
  case RDI_rtk_char_or_string: return out << "char_or_string";
  case RDI_rtk_abstime:        return out << "abstime";
  case RDI_rtk_reltime:        return out << "reltime";
  case RDI_rtk_dynany:         return out << "dynany";
  }
  return out << "(XXX unexpected RDI_TCKind value)" << (unsigned long)tckind;
}


// XXX we could expand the complex typecodes
inline
ostream& operator<< (ostream& out, const CORBA::TypeCode &tc) {
  return out << tc.kind();
}

inline
ostream& operator<< (ostream& out, const RDI_RTVal& res) {
  out << "[tckind: " << res._tckind << ", val: ";
  switch (res._tckind) {
  case RDI_rtk_null: {
    break;
  }
  case RDI_rtk_void: {
    break;
  }
  case RDI_rtk_weak_long: {
    out << res._v_long;
    break;
  }
  case RDI_rtk_short: {
    out << res._v_short;
    break;
  }
  case RDI_rtk_ushort: {
    out << res._v_ushort;
    break;
  }
  case RDI_rtk_long: {
    out << res._v_long;
    break;
  }
  case RDI_rtk_ulong: {
    out << res._v_ulong;
    break;
  }
  case RDI_rtk_float: {
    out << res._v_float;
    break;
  }
  case RDI_rtk_double: {
    out << res._v_double;
    break;
  }
  case RDI_rtk_boolean: {
    out << (res._v_boolean ? "TRUE" : "FALSE");
    break;
  }
  case RDI_rtk_char: {
    out << '\'' << res._v_char << '\'' ;
    break;
  }
  case RDI_rtk_octet: {
    out << res._v_octet;
    break;
  }
  case RDI_rtk_enum_ident: {
    out << res._v_string_ptr;
    break;
  }
  case RDI_rtk_enum_val: {
    // expand the typecode?
    char* id = 0;
    CORBA::ULong l = 0;
    try {
      id = res._v_enumval._my_ptr->value_as_string();
      l  = res._v_enumval._my_ptr->value_as_ulong();
      out << "(as_ulong: " << l << "   as_ident: " << (id ? id : "") << ")";
    } catch (...) {
      out << "(XXX could not extract ident or ulong from enum value)"; 
    }
    if (id) CORBA_STRING_FREE(id);
    break;
  }
  case RDI_rtk_string: {
    out << '\"' << res._v_string_ptr << '\"' ;
    break;
  }
  case RDI_rtk_char_or_string: {
    out << '\'' << res._v_string_ptr << '\'' ;
    break;
  }
  case RDI_rtk_abstime: {
    out << res._v_abstime;
    break;
  }
  case RDI_rtk_reltime: {
    out << res._v_reltime;
    break;
  }
  case RDI_rtk_dynany: {
    CORBA::TypeCode_var tmp_tcp = res._v_dynanyval._my_ptr->type();
    out << "(ptr:" << (void*)res._v_dynanyval._my_ptr << ", kind: " << (*tmp_tcp) << ")";
    break;
  }
  } // endsw
  return out << "]";
}

inline
ostream& operator<< (ostream& out, const CORBA::Any &a) {
  CORBA::TypeCode_var tmp_tcp = a.type();
  out << "Any[type: " << *(tmp_tcp) << ", val: ";

  while (1) {
    if (CORBA::_tc_null->equivalent(tmp_tcp))      { break; }
    if (CORBA::_tc_void->equivalent(tmp_tcp))      { break; }
    if (CORBA::_tc_short->equivalent(tmp_tcp))     { CORBA::Short c;    a >>= c; out << c; break; }
    if (CORBA::_tc_long->equivalent(tmp_tcp))      { CORBA::Long c;     a >>= c; out << c; break; }
    if (CORBA::_tc_ushort->equivalent(tmp_tcp))    { CORBA::UShort c;   a >>= c; out << c; break; }
    if (CORBA::_tc_ulong->equivalent(tmp_tcp))     { CORBA::ULong c;    a >>= c; out << c; break; }
    if (CORBA::_tc_float->equivalent(tmp_tcp))     { CORBA::Float c;    a >>= c; out << c; break; }
    if (CORBA::_tc_double->equivalent(tmp_tcp))    { CORBA::Double c;   a >>= c; out << c; break; }
    if (CORBA::_tc_boolean->equivalent(tmp_tcp))   { CORBA::Boolean c;  CORBA::Any::to_boolean to_c(c); a >>= to_c; out << c; break; }
    if (CORBA::_tc_char->equivalent(tmp_tcp))      { CORBA::Char c;   CORBA::Any::to_char to_c(c);  a >>= to_c; out << c; break; }
    if (CORBA::_tc_octet->equivalent(tmp_tcp))     { CORBA::Octet c; CORBA::Any::to_octet to_c(c); a >>= to_c; out << c; break; }

    if (CORBA::_tc_string->equivalent(tmp_tcp))    {  char* c = 0; a >>= c; out << c; break; }
    if (CORBA::_tc_TypeCode->equivalent(tmp_tcp))  { CORBA::TypeCode_ptr c; a >>= c; out << *c; break; }
    // other cases -- some would require constructing DynAny and extracting parts
    out << "(TODO)";
    break;
  }
  out << "]" << endl;
  return out;
}

inline
ostream& operator<< (ostream& out, const CosN_Property& prop) {
  return out << "name: " << prop.name << " value: " << prop.value;
}
  
inline
ostream& operator<< (ostream& out,
		     const _CORBA_Unbounded_Sequence<CosN_Property>& propseq) {
  for (unsigned int i = 0; i < propseq.length(); i++) {
    out << propseq[i] << endl;
  }
  return out;
}

inline
ostream& operator<< (ostream& out, const CosN_PropertyRange &range) {
    return out << "range "
	       << " : [" << range.low_val << " , " << range.high_val << "]";
}

inline ostream& operator<< (ostream& out, CosN_StructuredEvent& e) {
  const char* ename = (e.header.fixed_header.event_name ? e.header.fixed_header.event_name : "");
  const char* dname = (e.header.fixed_header.event_type.domain_name ? e.header.fixed_header.event_type.domain_name : "");
  const char* tname = (e.header.fixed_header.event_type.type_name ? e.header.fixed_header.event_type.type_name : "");
  out << "Event with event_name = " << ename << endl;
  out << "  dname::tname = " << dname << "::" << tname << endl;
  out << "  Variable header fields:" << e.header.variable_header;
  out << "  Filterable data fields:" << e.filterable_data;
  out << "  Body:" << endl << e.remainder_of_body << endl << endl;
  return out;
}

inline
ostream& operator<< (ostream& out, const CosN_PropertyError &e) {
  return out << "error " << e.code << " " << e.available_range;
}

inline
ostream& operator<< (ostream& out, const CosN_PropertyErrorSeq &s) {
    for (unsigned int i = 0; i < s.length(); i++) {
      out << s[i] << endl;
    }
    return out;
}

inline
ostream& operator<< (ostream& out, const CosN_UnsupportedAdmin &ua) {
  return out << "Exception CosN_UnsupportedQoS admin_err = "
	     << endl << ua.admin_err;
}

inline
ostream& operator<< (ostream& out, const CosN_UnsupportedQoS &uqos) {
  return out << "Exception CosN_UnsupportedAdmin qos_err = "
	     << endl << uqos.qos_err;
}

// XXXTBD
inline
ostream& operator<< (ostream& out, const CORBA::Exception &e) {
    return out << "CORBA::Exception [better description TBD]";
}

// -------------------------------------------------------------------


inline
ostream& operator<< (ostream& out, const RDI_Op& op) {

  out << RDI_OpCode2string[op._code] << " ";

  switch (op._argT) {
  case RDI_OpArgT_none:
    // no arg
    break;
  case RDI_OpArgT_sc:
    // string const
    out << "sc:\"" << op._arg._v_sc << "\"";
    break;
  case RDI_OpArgT_bc:
    if (op._arg._v_bc) {
      out << "bc:TRUE";
    } else {
      out << "bc:FALSE";
    }
    break;
  case RDI_OpArgT_lc:
    out << "lc:" << op._arg._v_lc;
    break;
  case RDI_OpArgT_dc:
    out << "dc:" << op._arg._v_dc;
    break;
  case RDI_OpArgT_lbl:
    out << "lbl: " << op._arg._v_lbl._lbl << "(offset " << op._arg._v_lbl._offset << ")";
    break;
  }
  return out;
}

// -------------------------------------------------------------------
#endif
