// This application implements an Event Service push supplier.
// It generates CORBA::Any events that contain a CORBA::ULong. 
 
#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include "corba_wrappers.h"
#include "CosNotify.h"

// *************************************************************** //

class MyPushSupplier_i : 
	WRAPPED_SKELETON_SUPER(CosNC::, PushSupplier) {
public:
  MyPushSupplier_i()	{;}
  void disconnect_push_supplier( WRAPPED_DECLARG_VOID ) {;}
  void subscription_change(const CosN_EventTypeSeq& added,
			   const CosN_EventTypeSeq& deled  WRAPPED_DECLARG ) {;}
};

// *************************************************************** //

static void usage(const char* pname)
{
   cout << "Usage: " << pname << " [-d numb] [-n name] [-v]" << endl;
   cout << "       -d numb : disconnect after numb pushes" << endl;
   cout << "       -n name : channel name [\"EventChannel\"]" << endl;
   cout << "       -v      : verbose output mode" << endl;
}

// *************************************************************** //

int main(int argc, char** argv)
{
  CORBA::Boolean verbose = 0;
  char *channelName = (char *) "EventChannel";
  int evnum = 10, c;

  // Parse command line arguments and initialize global variables

  while ( (c = getopt(argc, argv,"d:n:v")) != EOF ) {
  	switch (c) {
        case 'd': evnum = atoi(optarg);
                  break;
        case 'n': channelName = optarg;
                  break;
 	case 'v': verbose = 1;
		  break;
        default : usage(argv[0]);
                  exit(-1);
     }
  }

  CORBA::ORB_ptr orb = WRAPPED_ORB_INIT(argc, argv);
  CORBA::BOA_ptr boa = WRAPPED_BOA_INIT(orb, argc, argv);

  MyPushSupplier_i* supl = new MyPushSupplier_i();

  WRAPPED_ORB_REGISTER_SERVANT_NAME(orb, "event_push_supplier");
  WRAPPED_BOA_OBJ_IS_READY(boa, supl);

  WRAPPED_IMPL_IS_READY_FORK(boa, "event_push_supplier");

  try {
  	CosNaming::Name                             name;
	CORBA::Object_var                           echannel_ref;
	CORBA::Object_var                           name_service;
  	CosNaming::NamingContext_var                name_context;
  	CosEventChannelAdmin::EventChannel_var      channel;
  	CosEventChannelAdmin::SupplierAdmin_var     sadmin;
	CosEventChannelAdmin::ProxyPushConsumer_var pcons;

	if ( verbose ) 
		cout << "Resolving reference to: 'NameService'" << endl;
	name_service = WRAPPED_RESOLVE_INITIAL_REFERENCES(orb, "NameService"); 
	name_context = CosNaming::NamingContext::_narrow(name_service);
	if ( CORBA::is_nil(name_context) ) {
		cerr << "Failed to obtain context for NameService" << endl;
		exit(1);
	}
	name.length(1);
	name[0].id   = CORBA::string_dup(channelName);
	name[0].kind = CORBA::string_dup(channelName);
	if ( verbose ) 
		cout << "Resolving reference to: '"<<channelName<<"'" << endl;
	echannel_ref = name_context->resolve(name);
        channel = CosNA_EventChannel::_narrow(echannel_ref);
        if ( CORBA::is_nil(channel) ) {
                cerr << "Failed to narrow Event Channel !" << endl;
		exit(1);
        }

	if ( verbose ) 
		cout << "Creating new ConsumerAdmin object" << endl;
	sadmin = channel->for_suppliers();
	if ( CORBA::is_nil(sadmin) ) {
		cerr << "Failed to find Supplier Admin !" << endl;
		exit(1);
	}

	pcons = sadmin->obtain_push_consumer();
	if ( CORBA::is_nil(pcons) ) {
		cerr << "Failed to obtain ProxyPushConsumer !" << endl;
		exit(-1);
	}
	pcons->connect_push_supplier(supl->_this());
	for (CORBA::ULong i=1; i <= (CORBA::ULong)evnum; i++) {
		CORBA::Any any;
		any <<= i;
		pcons->push(any);
		if ( verbose ) 
			cout << "Pushed event: " << i << endl;
	}
	pcons->disconnect_push_consumer();
	WRAPPED_DISPOSE(supl->_this());
  } catch(CORBA::ORB::InvalidName& ex) {
        cerr << "Service required is invalid [does not exist]" << endl;
        exit(1);
#if defined (__OMNIORB2__) || defined (__OMNIORB3__)
  } catch (CORBA::COMM_FAILURE& ex) {
        cerr << "Caught system exception COMM_FAILURE" << endl;
        exit(1);
#endif
  } catch (CosEventChannelAdmin::AlreadyConnected& ex) {
	cerr << "Push Consumer already connected !" << endl;
	exit(1);
  } catch (CORBA::BAD_PARAM& ex) {
	cerr << "BAD_PARAM Exception while connecting Push Consumer !" << endl;
	exit (1);
  } catch (...) {
        cerr << "Caught exception while resolving the naming service" << endl;
        exit(1);
  }
  return 0;
}
