#include "RPii.h"

/*Prototypes*/

cwiid_mesg_callback_t RPii_callback;
int Get_Control_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control);
int RPii_Set_Ctrl_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control);
struct Log_Control *Pointto_Control_Data(cwiid_wiimote_t *wiimote);
int RPii_Connect_wiimote (cwiid_wiimote_t **wiimote);
int Disconnect_wiimote(cwiid_wiimote_t *wiimote);

/*MACROS*/
// Used to toggle the output to the wii. e.g for turning LEDs on.
#define toggle_bit(bf,b)	\
	(bf) = ((bf) & b)		\
	       ? ((bf) & ~(b))	\
	       : ((bf) | (b))


//************Connection functions******************//
//
//
//A function to connect to the wiimote
//
int RPii_Connect_wiimote (cwiid_wiimote_t **wiimote){

	bdaddr_t bdaddr;	/* bluetooth device address */
	//Rather than specifying a specific wiimote address, take the first one found:
	bdaddr = *BDADDR_ANY;
	
	/* Connect to the wiimote */
	printf("Put Wiimote in discoverable mode now (press 1+2)...\n");
	if (!(*(wiimote) = cwiid_open(&bdaddr, 0))) {
		fprintf(stderr, "Unable to connect to wiimote\n");
		exit(-1);
	}
	
	//printf("setting mesg callback\n");
	if (cwiid_set_mesg_callback(*(wiimote), RPii_callback)) {
		fprintf(stderr, "Unable to set message callback\n");
	}
	
	//Toggle BTN and ACC mesgs in callback
	unsigned char rpt_mode = 0;
	toggle_bit(rpt_mode, CWIID_RPT_ACC);
	toggle_bit(rpt_mode, CWIID_RPT_BTN);		
	cwiid_set_rpt_mode(*(wiimote), rpt_mode);
	
	//Turn on Wii LED1 so show connection
	// Create variables for writing to cwiid
	unsigned char led_state = 0;
	toggle_bit(led_state, CWIID_LED1_ON);
	cwiid_set_led(*(wiimote), led_state);
	
	//enable message reading (Taken from the 'case m' in wmdemo)
	// See Process_BTN_Output for button response
	cwiid_enable(*(wiimote), CWIID_FLAG_MESG_IFC);
	//RPii->Control.log_flags.mesgStream_on = true;
	
	//Check that wiimote has been initialised successfully
	if(*(wiimote) == NULL){
		fprintf(stderr, "Error, Pointer to wiimote struct is NULL, wiimote has not been connected successfully\n");
		exit(-1);
	}
	printf ("Connection Complete\n");
	return 0;
}
	
//
// A function to disconnect a wiimote
//
int Disconnect_wiimote(cwiid_wiimote_t *wiimote){
	if(cwiid_close(wiimote)){
		fprintf(stderr, "Error on wiimote disconnect \n");
	}
	return 1;
}
//
// A function to update Log_Control when passing by reference from a source file
//
int Get_Control_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control){
	Control = Pointto_Control_Data(wiimote);
	return 1;
}
//	
//A function to return the Control Data from wiimote
//
struct Log_Control *Pointto_Control_Data(cwiid_wiimote_t *wiimote){
	return (struct Log_Control*)(cwiid_get_data(wiimote));
}
//
//A function to set Control Data to wiimote
//
int RPii_Set_Ctrl_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control){
	cwiid_set_data(wiimote, (const void*)Control);
		return 1;
}
//
// The Callback Thread which toggles the btn and application flags
//
void RPii_callback(cwiid_wiimote_t *wiimote, int mesg_count, union cwiid_mesg mesg[], struct timespec *timestamp){

	int i, j, k;
	int valid_source;
	struct Log_Control Control;

	for (i=0; i < mesg_count; i++)
	{
		switch (mesg[i].type) {
		case CWIID_MESG_STATUS:
			printf("Status Report: battery=%d extension=",
			       mesg[i].status_mesg.battery);
			switch (mesg[i].status_mesg.ext_type) {
			case CWIID_EXT_NONE:
				printf("none");
				break;
			case CWIID_EXT_NUNCHUK:
				printf("Nunchuk");
				break;
			case CWIID_EXT_CLASSIC:
				printf("Classic Controller");
				break;
			case CWIID_EXT_BALANCE:
				printf("Balance Board");
				break;
			case CWIID_EXT_MOTIONPLUS:
				printf("MotionPlus");
				break;
			default:
				printf("Unknown Extension");
				break;
			}
			printf("\n");
			break;
			
//When Button Reporting is set the following is executed
//**************************************************************************//
		case CWIID_MESG_BTN:
			
			//fill the new Control struct with the infomation currently in wiimote
			Process_Mesg_BTN(Pointto_Control_Data(wiimote), mesg[i].btn_mesg.buttons);
			//(struct Log_Control*)cwiid_get_data(wiimote)
			break;
		
//When Accelerometer Reporting is set the following is executed
//*************************************************************************//
		
		case CWIID_MESG_ACC:
			
			//fill the new Control struct with the infomation currently in wiimote
			Process_Mesg_ACC(Pointto_Control_Data(wiimote), mesg[i].acc_mesg);
		
			break;

//*************************************************************************//			

		case CWIID_MESG_IR:
			printf("IR Report: ");
			valid_source = 0;
			for (j = 0; j < CWIID_IR_SRC_COUNT; j++) {
				if (mesg[i].ir_mesg.src[j].valid) {
					valid_source = 1;
					printf("(%d,%d) ", mesg[i].ir_mesg.src[j].pos[CWIID_X],
					                   mesg[i].ir_mesg.src[j].pos[CWIID_Y]);
				}
			}
			if (!valid_source) {
				printf("no sources detected");
			}
			printf("\n");
			break;
		case CWIID_MESG_NUNCHUK:
			printf("Nunchuk Report: btns=%.2X stick=(%d,%d) acc.x=%d acc.y=%d "
			       "acc.z=%d\n", mesg[i].nunchuk_mesg.buttons,
			       mesg[i].nunchuk_mesg.stick[CWIID_X],
			       mesg[i].nunchuk_mesg.stick[CWIID_Y],
			       mesg[i].nunchuk_mesg.acc[CWIID_X],
			       mesg[i].nunchuk_mesg.acc[CWIID_Y],
			       mesg[i].nunchuk_mesg.acc[CWIID_Z]);
			break;
		case CWIID_MESG_CLASSIC:
			printf("Classic Report: btns=%.4X l_stick=(%d,%d) r_stick=(%d,%d) "
			       "l=%d r=%d\n", mesg[i].classic_mesg.buttons,
			       mesg[i].classic_mesg.l_stick[CWIID_X],
			       mesg[i].classic_mesg.l_stick[CWIID_Y],
			       mesg[i].classic_mesg.r_stick[CWIID_X],
			       mesg[i].classic_mesg.r_stick[CWIID_Y],
			       mesg[i].classic_mesg.l, mesg[i].classic_mesg.r);
			break;
		case CWIID_MESG_BALANCE:
			printf("Balance Report: right_top=%d right_bottom=%d "
			       "left_top=%d left_bottom=%d\n",
			       mesg[i].balance_mesg.right_top,
			       mesg[i].balance_mesg.right_bottom,
			       mesg[i].balance_mesg.left_top,
			       mesg[i].balance_mesg.left_bottom);
			break;
		case CWIID_MESG_MOTIONPLUS:
			printf("MotionPlus Report: angle_rate=(%d,%d,%d)\n",
			       mesg[i].motionplus_mesg.angle_rate[0],
			       mesg[i].motionplus_mesg.angle_rate[1],
			       mesg[i].motionplus_mesg.angle_rate[2]);
			break;
		case CWIID_MESG_ERROR:
			if (cwiid_close(wiimote)) {
				fprintf(stderr, "Error on wiimote disconnect\n");
				exit(-1);
			}
			exit(0);
			break;
		default:
			printf("Unknown Report");
			break;
		}
	}
}
//
//
//
//