
#include <cwiid.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>
#include <sys/time.h>
#include <math.h>
#include <bluetooth/bluetooth.h>


/* Exit type flags */
#define EXIT_TIME		0x01
#define EXIT_SAMPLES	0x02
#define EXIT_BUTTONB	0x04

/* Calibration flags*/
#define CALX			0x01
#define CALY			0x02
#define CALZ			0x04
#define NOCALX		0x11
#define NOCALY		0x12
#define NOCALZ		0x14

/*GLOBAL CONSTS*/
#define GRAVITY	9.81

//RPiTeachingRes Structs
/******************************************************/
struct Acc_Data {
	int X;
	int Y;
	int Z;
};

struct Calibration_Consts {
	float mz;
	float cz;
	float my;
	float cy;
	float mx;
	float cx;
};

struct files {
	FILE *dataFile;
	FILE *infoFile;
	char* filename;
};

struct samples {
	int max;
	int count;
	int wait;
	int LogDuration;
	int wait_offset;
	int wait_adjusted;
};

struct PRNTACC{
	int X;
	int Y;
	int Z;
	int axes_comb;
};

struct log_flags {
	bool dataFile_Open;
	bool Get_Sample;
	bool Enable_Log;
	bool End_Loop;
	bool Chnge_Set;
	bool calibrating;
	bool mesgStream_on;
	bool Exit_BTN;
	struct PRNTACC PRNTACC;
	int Exit_type;
};

struct btn_flags{
	bool A_flag;
	bool B_flag;
	bool HOME_flag;
	bool PLUS_flag;
	bool MINUS_flag;
	bool RIGHT_flag;
	bool LEFT_flag;
	bool UP_flag;
	bool DOWN_flag;
	bool ONE_flag;
	bool TWO_flag;
};

struct Log_Control {
	struct files files; /*Contains pointers to filenames*/
	struct samples samples; /*Contains info about the sampling*/
	struct log_flags log_flags; /* Contains flags associated with collecting ACC data*/
	struct btn_flags btn_flags;
	struct timeval sampleTime;// Places to store times
	struct timeval startTime;//
	struct timeval startLoop;//
	struct timeval endLoop;//
	struct cwiid_state state;// For use with cwiid_get_state(wiimote, &state): contains most recent output from wiimote
	struct Acc_Data Acc_Data;// To Pass into the Print_ACC function
	struct Calibration_Consts Cal_Consts;
};

struct RPii {
	cwiid_wiimote_t *wiimote;
	struct Log_Control Control;
};
/*****************************************************/

/* RPiResources*/
//Top Level Main
int RPii_Initialise_Wiimote(struct RPii *RPii);
int RPii_LogAccApp(struct RPii *RPii);
int Log_Calibrate(struct RPii *RPii);
int Log_MotionLogger(struct RPii *RPii);
//Process Functions
int Process_Mesg_ACC(struct Log_Control *Control, struct cwiid_acc_mesg acc_mesg);
int Process_State_ACC(struct Log_Control *Control);
int Process_Mesg_BTN(struct Log_Control *Control, uint16_t BTNPressed);
int Process_EndOfLog( struct Log_Control *Control, char* filename);
float Process_Time_diff(struct timeval t1, struct timeval t2);
char* Process_CreateTimestamp(void);
int Process_OpenFilename(struct files *files, char *filename);
float Process_Calibrate_Value(struct Log_Control *Control, int CalAxis);
//Control Functions
int Toggle_ACC_Mesg(struct RPii *RPii);
int Toggle_ACC_prnts(struct PRNTACC *tempprnt);
int Control_Change_Settings(struct RPii *RPii);
int RPii_Set_Ctrl_Defaults(struct RPii *RPii);
//Recording Functions
int Rec_Data(struct Log_Control *Control);
int Rec_Acc_Data(struct Log_Control *Control);
int Rec_DataTime(struct Log_Control *Control);
int Rec_dataFileHeader(struct Log_Control *Control);
//Print Functions
int Print_Ctrl_Settings(struct Log_Control Control);
void Print_Countdown(int wait, int values);
void Print_App_Ctrls( void );
void Print_EditSet_Ctrls ( void );
void Print_wiimote_data(struct RPii *RPii, bool all);
void RPii_Prnt_Ctrl_Settings(struct Log_Control Control, bool all);
//LED Functions
int LEDs_Mod4(struct RPii *RPii, int samplecount);
int LEDs_All_Flash(struct RPii *RPii);
//Connect functions
cwiid_mesg_callback_t RPii_callback;
int Get_Control_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control);
int RPii_Set_Ctrl_Data(cwiid_wiimote_t *wiimote, struct Log_Control *Control);
struct Log_Control *Pointto_Control_Data(cwiid_wiimote_t *wiimote);
int RPii_Connect_wiimote (cwiid_wiimote_t **wiimote);
int Disconnect_wiimote(cwiid_wiimote_t *wiimote);
//Other Functions
bool exit_type_satisfied(struct Log_Control *Control);

