/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <sys/types.h>
#include <stdio.h>

extern unsigned long drift_period;

struct __clock_retimer_st;
typedef struct __clock_retimer_st clock_retimer_t;

void getTime(clock_retimer_t *timer, unsigned long nictstamp,
	     struct timeval *tv, struct timespec *ts);
int doTimer(clock_retimer_t *timer, unsigned long nictstamp,
	    unsigned total_pkts);
long card_tstamp_getcurtime(const char *name);
unsigned long skb_to_nictstamp(const struct sk_buff *skb);

clock_retimer_t *new_clock_retimer(const char *name, unsigned dev_num);

void initialise_timestamps(unsigned do_clock_retime,
			   unsigned long initial_freq,
			   const char *drift_fname);
