Summary: dumps packets that are sent or received over a network interface
Name: tcpdump
Version: 3.4
%define	tcpdump_dir	tcpdump-3.4
Release: 5
# XXX serial number is necessary to obsolete tcpdump-3.4a5
Serial: 1
Copyright: BSD
Group: Applications/Networking
Source0: ftp://ftp.ee.lbl.gov/tcpdump-3.4.tar.Z
Source1: ftp://ftp.ee.lbl.gov/libpcap-0.4.tar.Z
Source2: ftp://ftp.ee.lbl.gov/arpwatch-2.1a4.tar.Z
Source3: arpwatch.init
Patch0: tcpdump-3.4a5-man.patch
Patch1: tcpdump-3.4a5-sack.patch
Buildroot: /var/tmp/tcpdump-root
Summary(de): deponiert Pakete, die ber eine Netzwerkschnittstelle gesandt oder empfangen werden  
Summary(fr): vide les paquets mis ou reus sur une interface rseau
Summary(tr): Bir a arabirimi zerinden gelen ya da giden paketleri listeler

%description
Tcpdump prints out the headers of packets on a network interface.  It
is very useful for debugging network problems and security operations.

%description -l de
Tcpdump druckt die Headers von Paketen auf einer Netzschnittstelle. 
Es ist beraus ntzlich zum Debuggen von Netzwerkproblemen und von
Sicherheitsoperationen.

%description -l fr
tcpdump affiche les en-ttes des paquets d'une interface rseau. Il est
trs utile pour dtecter les problmes de rseau et de scurit.

%description -l tr
Tcpdump, bir a arabirimi zerinden geen paketlerin balklarn dker.
Gvenlik ilemleri ve a problemlerinin irdelenmesi konularnda son derece
yararldr.

%package -n libpcap
Version: 0.4
%define	libpcap_dir	libpcap-0.4
Summary: Libpcap provides promiscuous mode access to network interfaces.
Group: Applications/Networking

%description -n libpcap
Libpcap is a system-independent interface for user-level packet capture.
Libpcap provides a portable framework for low-level network monitoring.
Applications include network statistics collection, security monitoring,
network debugging, etc. Libpcap has system-independent API that is used
by several applications, including tcpdump and arpwatch.

%package -n arpwatch
Version: 2.1a4
%define	arpwatch_dir	arpwatch-2.1a4
Summary: Arpwatch monitors changes in ethernet/ip address pairings.
Group: Applications/Networking

%description -n arpwatch
Arpwatch and arpsnmp are tools that monitors ethernet or fddi activity and
maintain a database of ethernet/ip address pairings.

%prep
%setup -q -c -a 1 -a 2

cd %tcpdump_dir
%patch0 -p2
%patch1 -p2
cd ..

%build
cd %libpcap_dir
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
make
cd ..

cd %tcpdump_dir
CFLAGS="$RPM_OPT_FLAGS -DIP_MAX_MEMBERSHIPS=20" ./configure --prefix=/usr
make
cd ..

cd %arpwatch_dir
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
make ARPDIR=/var/arpwatch
cd ..

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/{include/pcap/net,lib,man/man3,man/man8,sbin}

cd %libpcap_dir
make DESTDIR=$RPM_BUILD_ROOT INCLDEST=/usr/include/pcap install install-incl install-man
cd ..

cd %tcpdump_dir
install -m755 -s tcpdump $RPM_BUILD_ROOT/usr/sbin
install -m644 tcpdump.1 $RPM_BUILD_ROOT/usr/man/man8/tcpdump.8
cd ..

cd %arpwatch_dir
make DESTDIR=$RPM_BUILD_ROOT install install-man
mkdir -p $RPM_BUILD_ROOT/var/arpwatch
for n in arp2ethers massagevendor; do
	install -m755 $n $RPM_BUILD_ROOT/var/arpwatch
done
for n in *.awk *.dat; do
	install -m644 $n $RPM_BUILD_ROOT/var/arpwatch
done
( cd $RPM_BUILD_ROOT
  mkdir -p ./etc/rc.d/init.d
  install -m755 $RPM_SOURCE_DIR/arpwatch.init ./etc/rc.d/init.d/arpwatch
)
cd ..

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc	%tcpdump_dir/README %tcpdump_dir/CHANGES
/usr/sbin/tcpdump
/usr/man/man8/tcpdump.8

%files -n libpcap
%defattr(-,root,root)
%doc	%libpcap_dir/README %libpcap_dir/CHANGES
/usr/include/pcap
/usr/lib/libpcap.a
/usr/man/man3/pcap.3

%files -n arpwatch
%doc	%arpwatch_dir/README %arpwatch_dir/CHANGES
/usr/sbin/arpwatch
#/usr/sbin/arpsnmp
/usr/man/man8/arpwatch.8
#/usr/man/man8/arpsnmp.8
/etc/rc.d/init.d/arpwatch
%dir	/var/arpwatch
%config	/var/arpwatch/arp.dat
%config	/var/arpwatch/ethercodes.dat
/var/arpwatch/*.awk
/var/arpwatch/arp2ethers
/var/arpwatch/massagevendor

%changelog
* Tue Sep 29 1998 Jeff Johnson <jbj@redhat.com>
- libpcap description typo.

* Sat Sep 19 1998 Jeff Johnson <jbj@redhat.com>
- fix arpwatch summary line.

* Mon Aug 17 1998 Jeff Johnson <jbj@redhat.com>
- enable arpwatch

* Mon Aug  3 1998 Jeff Johnson <jbj@redhat.com>
- separate package for libpcap.
- update tcpdump to 3.4, libpcap to 0.4.
- added arpwatch (but disabled for now)

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sat May  2 1998 Alan Cox <alan@rehat.com>
- Added the SACK printing fix so you can dump Linux 2.1+.

* Tue Oct 21 1997 Erik Troan <ewt@redhat.com>
- updated to release 3.4a5
- uses a buildroot and %attr 

* Thu Jul 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc
