/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <errno.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>
#include <signal.h>
#include <limits.h>
#include <assert.h>

#include "basic_defs.h"

#include "list.h"

#include "pkt.h"
#include "seq.h"
#include "flows.h"
#include "service.h"
#include "http.h"
#include "tcp.h"
#include "udp.h"
#include "udp_ns.h"
#include "icmp.h"
#include "print_util.h"
#include "sundry_records.h"
#include "if_stats.h"
#include "procstat.h"
#include "report.h"
#include "output.h"
#include "counters.h"

#include "servers.h"
#include "wread_util.h"
#include "print_util.h"

#ifdef SWIG
#include "except.h"
#endif



void 
usage(void) 
{
  fprintf(stderr, "usage: %s <file>\n", prog);
  exit(1);

  return;
}


int 
wreport(struct np_file *file,  int allocflag, unsigned char type, 
	int keytype, unsigned int key, int quietflag) 
{
  if (!quietflag && !keytype && !type)
    report_counters(&file->counters, stdout, "");

  return _printfile(file, allocflag, type, keytype, key, quietflag);
}

      
int  
tell_all(char *file_name, unsigned char type, 
	 int keytype, unsigned int key, int quietflag)
{
  struct np_file *file;
  
  if ((file = (struct np_file *)malloc(sizeof(struct np_file))) == NULL)
    ERROR("main - np_file_t malloc fail");

  strcpy(file->fnm, file_name);

  _file_open(file);
  //fprintf(stderr, "reading type %hu\n", type);
  wreport(file, TRANS_PREALLOC, type, keytype, key, quietflag);

  free(file->offsets);
  free(file);

  return 0;
}


int  
tell(char *file_name)
{
  struct np_file *file;
  
  if ((file = (struct np_file *)malloc(sizeof(struct np_file))) == NULL)
    ERROR("main - np_file_t malloc fail");

  strcpy(file->fnm, file_name);

  _file_open(file);
  report_counters(&file->counters, stdout, "");

  free(file->offsets);
  free(file);

  return 0;
}

int 
main(int argc, char **argv)
{
  char c;
  int quietflag = 0;
  int keytype = 0;
  unsigned int key;
  struct in_addr addr;
  unsigned char type = REC_ALL;		/* default */
  prog = argv[0];
  opterr = 0;

  if (argc < 2)
    usage();


  while ((c = getopt(argc, argv, "S:C:R:nt:qc:")) != EOF)
    switch (c) 
      {
      case 'S': keytype = KEY_SERV_ADDR; 
	if ((key = inet_aton(optarg, &addr)) == 0)
	  {
	    fprintf(stderr, "Cannot translate address %s\n", optarg);
	    exit(1);
	  }
	key = addr.s_addr;
	break;
      case 'C': keytype = KEY_CLI_ADDR; 
	if ((key = inet_aton(optarg, &addr)) == 0)
	  {
	    fprintf(stderr, "Cannot translate address %s\n", optarg);
	    exit(1);
	  }
	key = addr.s_addr;
	break;
      case 'n': print_hostnames++; break;
      case 't': type = _parse_type(optarg); break;
      case 'q': quietflag++; break;
      case 'c': 
	keytype = KEY_CONN_ID; 
	//if ((key =strtoul(optarg, NULL, 0) == ULONG_MAX && errno == ERANGE))
	  //{
	    //fprintf(stderr, "Cannot get connid %s\n", optarg);
	    //exit(1);
	  //}
	key = atoi(optarg);
	    break;
      case 'R': 
	keytype = KEY_REC;
	key = atoi(optarg);
	//if ((key =strtoul(optarg, NULL, 0) == ULONG_MAX && errno == ERANGE))
	  //{
	    //fprintf(stderr, "Cannot get rec. no. %s\n", optarg);
	    //exit(1);
	  //}
	    break;
      default:
	usage();
	/* NOTREACHED */
      }

  if (optind == argc)
    usage();

  tell_all(argv[optind], type, keytype, key, quietflag);

  return 0;
}



/*
 * end wread.c 
 */
