/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/param.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "interface.h"
#include "flows.h"
#include "service.h"
#include "http.h"
#include "tcp_other.h"
#include "tcp.h"
#include "udp.h"
#include "udp_ns.h"
#include "seq.h"
#include "report.h"

#ifdef PRINT_OUT
#include "print_util.h"
#endif

#include "output.h"
#include "writer.h"
#include "pool.h"

/*****************************************************************************/

/*
 * Null (no action) service methods
 */

void 
tcp_other_open_na(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

void 
tcp_other_close_na(prec_t *pp, struct tcp_conn *tconnp, int way, unsigned char flags)
{
  return;
}

int 
tcp_other_pkt_na(prec_t *pp, struct tcp_conn *tconnp, int way)
{
  return 0;
}


int 
tcp_other_sync_na(struct tcp_heldpkt *hpp, struct tcp_conn *tconnp, 
		 struct tcp_simplex_flow *tsp, unsigned int gap, int way, 
	       unsigned int tm)
{
  return 1;
}
  
void 
tcp_other_dump_na(struct tcp_conn *tconnp)
{
  return;
}

/*****************************************************************************/

/*
 * Dump connection details at close method
 */
 
void 
tcp_other_dump_summary(struct tcp_conn *tconnp)
{
  int client_seen = TCP_STATE & TCP_CLIENT_SEEN;
  int server_seen = TCP_STATE & TCP_SERVER_SEEN;

  rec_dump_start();
  tcp_dump(tconnp, client_seen, server_seen);
  rec_dump_end(REC_TCP_OTHER);
  
  return;
}

/*****************************************************************************/

/*
 * Service method suite - no actions at all
 */

tcp_serv_methods_t tcp_other_serv_methods_na = 
  {
    tcp_other_open_na,
    tcp_other_pkt_na,
    tcp_other_sync_na,
    tcp_other_close_na,
    tcp_other_dump_na
  };

/*
 * Service method suite - no actions but dump connection summary
 */

tcp_serv_methods_t tcp_other_serv_methods_summary = 
  {
    tcp_other_open_na,
    tcp_other_pkt_na,
    tcp_other_sync_na,
    tcp_other_close_na,
    tcp_other_dump_summary
  };

/*****************************************************************************/

/*
 * Service control - no actions, no dumps, count as tcp_other
 */

serv_control_t tcp_other_serv_control_na = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_OTHER
    },
    &counters.TRAFF_TCP_OTHER,
    NO_DUMP
  };

/*
 * Service control - no actions, dump connection summary, count as tcp_other
 */

serv_control_t tcp_other_serv_control_summary = 
  {
    {
      (void *)&tcp_other_serv_methods_summary
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_OTHER
    },
    &counters.TRAFF_TCP_OTHER,
    NO_DUMP
  };

/*
 * Service control - no actions, dump connection open and summary, count as 
 * tcp_other
 */

serv_control_t tcp_other_serv_control_open_summary = 
  {
    {
      (void *)&tcp_other_serv_methods_summary
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_OTHER
    },
    &counters.TRAFF_TCP_OTHER,
    DUMP_OPEN
  };

/*
 * Service control - no actions, dump connection open, hdrs and summary, 
 * count as tcp_other
 */

serv_control_t tcp_other_serv_control_open_hdrs_summary = 
  {
    {
      (void *)&tcp_other_serv_methods_summary
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_OTHER
    },
    &counters.TRAFF_TCP_OTHER,
    DUMP_OPEN | DUMP_HDRS
  };

/*****************************************************************************/


/*
 * Service control for other recognised TCP services without service-specific 
 * tcp_*.c files
 */ 


/* Telnet */
serv_control_t tcp_telnet_serv_control = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_TELNET
    },
    &counters.TRAFF_TCP_TELNET,
    NO_DUMP
  }; 


/* Smtp */
serv_control_t tcp_smtp_serv_control = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_SMTP
    },
    &counters.TRAFF_TCP_SMTP,
    NO_DUMP
  }; 


/* Pop3 */
serv_control_t tcp_pop3_serv_control = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_POP3
    },
    &counters.TRAFF_TCP_POP3,
    NO_DUMP
  };


/* Nntp */
serv_control_t tcp_nntp_serv_control = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_NNTP
    },
    &counters.TRAFF_TCP_NNTP,
    NO_DUMP
  };


/* Netbios_Ssn */
serv_control_t tcp_netbios_ssn_serv_control = 
  {
    {
      (void *)&tcp_other_serv_methods_na
    },
    {
      REC_TCP_OTHER_OPEN, REC_TCP_OTHER_HDRS, REC_TCP_OTHER, TCP_SERV_NETBIOS_SSN
    },
    &counters.TRAFF_TCP_NETBIOS_SSN,
    NO_DUMP
  };

