/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#undef __STDC__
#include <netinet/ip.h>

#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#ifdef __alpha__
#include <net/if_llc.h>
#endif
#include <netinet/if_fddi.h>
#include <netinet/if_ether.h>
#include <sys/resource.h>

#include "list.h"
#include "pkt.h"
  

#ifdef TCPDUMP_FED
void 
get_start(struct timeval *tv)
{
  struct rusage r;

  if (getrusage(RUSAGE_SELF, &r) != 0)
    error("get_start", "getrusage");

  *tv = r.ru_utime;
}

void  
get_end(struct timeval *tv)
{
  struct rusage r;

  if (getrusage(RUSAGE_SELF, &r) != 0)
    error("get_start", "getrusage");

  *tv = r.ru_utime;
}

#else

void
get_start(struct timeval *tv)
{
  gettimeofday(tv, (struct timezone *)0);
}

void  
get_end(struct timeval *tv)
{
  gettimeofday(tv, (struct timezone *)0);
}

#endif

double 
calc_period(struct timeval *start, struct timeval *end)
{
  double st = start->tv_sec+(start->tv_usec/1000000.0);
  double en = end->tv_sec+(end->tv_usec/1000000.0);

  return en-st;
}


  

/*
 * end performance_timer.c 
 */
