/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/

#ifndef _OUTPUT_H_
#define _OUTPUT_H_


#ifdef WREAD

#undef REPORT
#undef MMAP_REPORT
#undef BIN_REPORT

#endif /* ifdef WREAD */

#define MAX_LOGDIR_LEN 512

#ifndef WREAD

/*
 * error.c 
 */
void error(char *msg, char *pmsg);

/*
 * output.c 
 */
extern char *prog;

extern char repfnm[PATH_MAX+1], dumpfnm[PATH_MAX+1];
void output_init(int snaplen, int chan, char *fnm);
void output_end(listhdr_t *host_hashtbl);
void write_repfile_preamble(struct timeval *time);
void write_counters(counters_t *counters, struct timeval *time);
void write_dumpfile_preamble(int snaplen);
void rec_dump_start();
void rec_dump_end(unsigned char type);
void repbuf_manage(int file_cycle, int cycle_sync, int finishing);
void dumpbuf_manage(int file_cycle, int cycle_sync, int finishing);

#endif /* ifndef WREAD */


#include "np_file.h"

#define CYCLE_STR_LEN 10

/*
 * If dumping TCP payloads the large number of concurrent connections may well
 * exceed the number of available fd.s - allow some spare capacity for rep and
 * dump files and housekeeping
 */
#define DUMP_FILE_N_SPARE_FDS 25


/*
 * Control output file sizes, file cycles, etc.
 * Relative report/dump file sizes need tuning for traffic seen but if 
 * dumping all packets 1:25 is about right, and if dumping only error causing 
 * packets 8:1
 */


#if defined LARGE_DUMP_FILES

#define REPORT_FILE_SZ (4*1024*1024)
#define DUMP_FILE_SZ   (500*1024*1024)

#else

#define REPORT_FILE_SZ (8*8*1024*1024)
#define DUMP_FILE_SZ   (8*8*128*1024)

#endif /* ifdef LARGE_DUMP_FILES */


#define ERR_DUMP_SZ_DEF 600

#define NOT_CYCLE_SYNC 0
#define CYCLE_SYNC 1

#define NO_CYCLE 0
#define CYCLE 1

#define NOT_FINISHING 0
#define FINISHING 1

/*
 * Rep file record header  - types defined in np_file.h
 */

#define REC_HDR_MAGIC 0x41424344

struct rep_rec_hdr 
{
#ifdef DUMP_DEBUG
  unsigned int magic;
  unsigned int len;
  unsigned int indx;
#else
  unsigned short len;
  unsigned char indx;
#endif
  unsigned char type;
};

typedef struct rep_rec_hdr rep_rec_hdr_t;

extern char *outp, *dumpp;  /* should this be in writer.h? --cpk25 */
extern char *dump_start;

extern char* o_infnm;
extern int o_snaplen, o_linktype;

extern char obj_dirnm[PATH_MAX+1];
extern char payload_dirnm[PATH_MAX+1];
extern int rep_fd, dump_fd;

#ifdef WREAD

#define REP(file, fmt, args...)           \
MACRO_BEGIN          \
fprintf((file), fmt, ## args);  \
MACRO_END 


#endif /* #ifdef WREAD */


#define DUMP_INT(buf, val, type)             \
MACRO_BEGIN                \
  *((type *)(buf)) = (val);                 \
  (buf)+= sizeof(type);                      \
MACRO_END

#define DUMP_STRUCT(buf, addr, type)             \
MACRO_BEGIN                \
  memcpy((buf), (addr), sizeof(type));                 \
  (buf)+= sizeof(type);                      \
MACRO_END

#define DUMP_STRING(buf, addr, len)             \
MACRO_BEGIN                \
  strcpy((buf), (addr));                 \
  (buf)+= ((len) + 1);                      \
MACRO_END

#define DUMP_MEM(buf, addr, len)             \
MACRO_BEGIN                \
  memcpy((buf), (addr), (len));                 \
  (buf)+= (len);                      \
MACRO_END

#endif /*_OUTPUT_H_*/

/*
 * end output.h 
 */
