#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
##
## 
## 
##
## 

############################################################################ 

#import string
from string import *
from Tkinter import *

class FontFrame(Frame):

    def draw_fonts(self, fonts):

	xbase = 25
	y = 25
	canv = self.draw

	for font in fonts[0]:
	    for size in fonts[2]:
		x = xbase
		for style in fonts[1]:
		    spec = (font, size, style)
		    txt = '%s %d point %s' % (font, size, style)
		    t =  canv.create_text(x,y,text=txt, font=spec, anchor=W)
		    bb = canv.bbox(t)
		    x = x + int((bb[2] - bb[0])*1.1)
		y = y+bb[3] - bb[1]

        for font in aliased_fonts:
            txt = '%s The quick fox jumped over the lazy brown dog' % (font)
            t = canv.create_text(xbase,y,text=txt, font=(font), anchor=W)
            bb = canv.bbox(t)
            y = y+bb[3] - bb[1]

    def createCanvas(self):

	self.draw = Canvas(self, width=750, height=750,
			   background="white",
			   scrollregion=(0, 0, 750, 750))


## 	self.draw.scrollY = Scrollbar(self, orient=VERTICAL)
## 	self.draw['yscrollcommand'] = self.draw.scrollY.set
## 	self.draw.scrollY['command'] = self.draw.yview
## 	self.draw.scrollY.pack(side=RIGHT, fill=Y)

	self.draw.pack(side=LEFT)


    def __init__(self, fonts, master=None):
	Frame.__init__(self, master)
	Pack.config(self)
	self.createCanvas()
	self.draw_fonts(fonts)
	
	self.mainloop()

#############################################################################
##############################################################################
 
fonts = [
    ['Helvetica', 'Times', 'Courier', 'Ariel'], 
    ['', 'bold' , 'italic'], 
    [6, 8, 10, 12, 14]
    ]

# From /usr/X11R6/lib/X11/fonts/misc/fonts.alias
aliased_fonts = ['5x7', '5x8', '6x9', '6x10', '6x12', '6x13', '6x13bold', '7x13', '7x13bold', '7x13euro', '7x13eurobold', '7x14', '7x14bold', '8x13', '8x13bold', '8x16', '9x15', '9x15bold', '10x20', '12x24', 'heb6x13', 'heb8x13']

f = FontFrame(fonts)
