/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


#ifndef WREAD
#define WREAD
#endif

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>
#ifdef __alpha__
#include <sys/mbuf.h>
#endif
#include <net/route.h>
#include <net/if.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#ifdef __alpha__
#include <netinet/ip_var.h>
#endif
#include <netinet/tcp.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>
#include <signal.h>

#include <linux/limits.h>

#include <assert.h>

#include "list.h"
#include "pkt.h"
#include "seq.h"
#include "flows.h"
#include "service.h"
#include "http.h"
#include "tcp.h"
#include "udp.h"
#include "udp_ns.h"
#include "icmp.h"
#include "print_util.h"
#include "procstat.h"
#include "sundry_records.h"
#include "if_stats.h"
#include "report.h"
#include "output.h"
#include "counters.h"
#include "writer.h"
#include "wread_util.h"
#include "http_util.h"

/*
 * Given a dumped in-line image or links buffer and index 
 * populate the link rec, return buffer index of next record
 *  - bufp is passed as a long because Python would otherwise attempt
 * to hold the buffer as a string object
 */
 
int 
_get_next_link_rec(struct linkrec *lp, int indx, long bufp)
{
  static int tm;
  char *chars = (char *)(bufp+indx);
  unsigned short ltype;
  static char null_str = '\0';

  lp->url = null_str;

  ltype = (unsigned short)*((unsigned char*)chars++);
  if (ltype == LR_HIGH)
    ltype = (unsigned short)(*((unsigned char*)chars++) << 8);

  lp->type = (int)ltype;

  if (ltype & LR_REFRESH)
    {
      lp->per = *((int *)chars);
      chars += 4;
    }
  

  if (ltype & LR_HAS_URL)
    {
      //printf('%s\n', chars);
      lp->url = chars;
      
      while (*(chars++) != '\0'); /* clear chars */
    }
  else if (ltype & LR_END_BASE)
    {
      ;				/* nothing */
    }
  else if (ltype == LR_TS)
    {
      tm = *((int *)chars);
      chars += sizeof(int);
    }
  else 
    {
#if 0
      sprintf(errbuf, "_get_next_link_rec(): unknown link record type %x", 
	      ltype);
      ERROR(errbuf);
#endif
      ;
				/* nothing */
    }
  lp->reltm = tm;

  return (int)((long)chars - bufp);
}

      
