#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#
# Inputs series of Nprobe logs, associates TCP connections by host pairs, 
# sorts by connection open time and prints out transactions (inputs only 
# HTTP connections).
# 

import string
import glob
import os
import sys
import nprobe
from sys import argv

import np_util

#############################################################################



#sort cmp function for list of tcp_conns by open time
def cmp_by_start(a, b):
	return np_util.cmp_us_clk(a.open(), b.open())

	#if a.start() > b.start():
		#return 1
	#elif a.start() < b.start():
		#return -1
	#else:
		#return 0

##############################################################################

#sort cmp function to sort list of host pair/tcp connection tuples 
# by connection time

def cmp_pair_by_start(a, b):
	return np_util.cmp_us_clk(a[1].open(),  b[1].open())

	#if a[1].start() > b[1].start():
		#return 1
	#elif a[1].start() < b[1].start():
		#return -1
	#else:
		#return 0
	 



##############################################################################

#
# given a list of open np_file objects build a dictionary associating 
# tcp connections by hosts 
# - key = (src_addr, dst_addr)
# - item = list of tcp connections

def ass_by_hosts(openfilelist):
	hostconns = {}
	nrecs = 0
	ntrans = 0

	#associate tcp conns by host pairs
	for file in openfilelist:
		i = 0
		#print file.counters.nrecords
		while i < file.counters.nrecords:
			#print i
			nrecs = nrecs + 1
			#print "total records ",
			#print nrecs
			connrec = nprobe.tcp_conn()
			#connrec.getconn_and_trans(file)
			while i < file.counters.nrecords:
			    i = i + 1
			    connrec.getconn(file)
			    if connrec.is_http():
				connrec.get_trans_chain(file)
				xtrans = connrec.ntrans()
				ntrans = ntrans + xtrans
				#print " transactions ",
				#print ntrans
				#connrec.printself()
				#print connrec.tcp.common.srcaddr
				key = (connrec.tcp.common.srcaddr, connrec.tcp.common.dstaddr)
				if not hostconns.has_key(key):
				    hostconns[key] = []
				hostconns[key].append(connrec)
				break

	return hostconns

##############################################################################


#
# given a dictionary of tcp connection lists keyed by host addresses sort 
# connection lists by connection open time 
# - return list of keys sorted by open time of first connection on list
#

def sort_host_conns_by_opentime(hostconns):
	keylist = hostconns.keys()

	#sort connection list for each host pair by open times and build list 
	# of host pair key/first connection time tuples

	pairtimelist = []

	for hostpair in keylist:
		connlist = hostconns[hostpair]
		connlist.sort(cmp_by_start)
		pair = (hostpair, connlist[0])
		pairtimelist.append(pair)
	
	#sort list of host pair key/first connection time tuples
	pairtimelist.sort(cmp_pair_by_start)

	return pairtimelist

##############################################################################


openfilelist, counters = np_util.get_files(sys.argv[1:])
counters.printself("")
hostconns = ass_by_hosts(openfilelist)
pairtimelist = sort_host_conns_by_opentime(hostconns)

#now output all connections sorted by start time

for tuple in pairtimelist:
	print "###########################################################################" 
	hostkey = tuple[0]
	nprobe.print_hostname(hostkey[0])
	print "<>",
	nprobe.print_hostname(hostkey[1])
	print"\n", 
	connlist = hostconns[hostkey]
	#print connlist[0].start()
	for conn in connlist:
		conn.printself()





