#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


##############################################################################
## 
## Smooth time series data by averaging over specified period (in s)
## 
## 
##
## 

############################################################################ 

import string
import glob
import os
import sys
import nprobe
from sys import argv
import getopt
from signal import *
from np_plot import *
	    
	     
##############################################################################

def usage():

    print 'usage dens.py -x<period s> -y<period s> <data file>'
    sys.exit(1)
	    
	     
##############################################################################

##############################################################################

def get_data(file):
    data = []
    f = open(file, 'r')
    n = 0
    line = 0
    while 1:
	s = f.readline()
	line = line +1
	if not len(s):
	    #print 'empty'
	    break
	if s[0] == '#' or s[0] == ' ' or s[0] =='\n':
	    #print 'comment'
	    continue
	vs = string.split(s)
	try:
	    data.append([string.atof(vs[0]), string.atof(vs[1])])
	    n = n + 1
	except IndexError:
	    print 'Malformed data line %d' % (line)
	    sys.exit (1)


    return (data, n)
	    
	     
##############################################################################

def bucket(d, xp, yp):

    d.sort()

    dout = []
    slen = 0

    xstart = d[0][0]
    xt = xstart + xp
    print 'xstart=%f xp = %f' % (xstart, xp)
    print 'xt now %.3f' % (xt)
    yvals = []
    for e in d:
	x = e[0]
	v = e[1]
	print e[0]
	if x > xt:
	    if len(yvals):
		yvals.sort()
		dens = 0
		ystart = yvals[0]
		yt = ystart + yp
		for yv in yvals:
		    y = yv - ystart
		    if y > yt:
			dout.append((xt, yt-(yp/2.0), dens))
			print 'app %f %f %d' % (xt, yt-(yp/2.0), dens)
			slen += 1
			while yt < y:
			    yt += yp
			#print 'yt now %.3f' % (yt)
			dens = 0
		    dens += 1

		if dens:
		   dout.append((xt, yt-(yp/2.0), dens))
		   print 'app %f %f %d' % (xt, yt-(yp/2.0), dens)
		   slen += 1 

	    while xt < x:
		xt += xp
	    print 'xt now %.3f' % (xt)
	    yvals = []

	yvals.append(v)
	#print 'appending yval %.3f' % (v)



    if len(yvals):
	print 'xt now %.3f' % (xt)
	yvals.sort()
	dens = 0
	ystart = yvals[0]
	yt = ystart + yp
	for yv in yvals:
	    y = yv - ystart
	    if y > yt:
		dout.append((xt, yt-(yp/2.0), dens))
		print 'app %f %f %d' % (xt, yt-(yp/2.0), dens)
		slen += 1
		while yt < y:
		    yt += yp
		dens = 0
	    dens += 1

	    if dens:
		dout.append((xt, yt-(yp/2.0), dens))
		print 'app %f %f %d' % (xt, yt-(yp/2.0), dens)
		slen += 1

    

    for d in dout:
	print '%10.3f %10.3f %.d' % (d[0], d[1], d[2])
    
    return (dout, slen)
		

    
	    
	     
############################################################################## 


def main():

    xp = 1.0
    yp = 1.0
    
    try:
        optlist, args = getopt.getopt(sys.argv[1:], 'x:y::h')
	
    except getopt.error, s:
        print 'dens: ' + s
        usage()
        sys.exit(1)
	
    for opt in optlist:
	if opt[0] == "-h":
	    usage(scriptname)
	if opt[0] == "-x":
	    xp = string.atof(opt[1])
	if opt[0] == "-y":
	    yp = string.atof(opt[1])

    if not xp:
	print 'No x period specified - defaulting to 1.0'
	usage()

    if not yp:
	print 'No x period specified - defaulting to 1.0'
	usage()

    if len(args) == 1:
	#print args
	data, dlen = get_data(args[0])
    else:
	print 'No data file specified'
	usage()

    basepath = args[0]

    dout, slen = bucket(data, xp, yp)
	

    of = raw_input('Save as: ')
    f = open(of, 'w')
    for d in dout:
	f.write('%10.3f %10.3f %.d\n' % (d[0], d[1], d[2]))

    return
	    
	     
##############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()
