#! /usr/bin/env python
###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################

import fmagic
from os import listdir
from os.path import isfile, join
from popen2 import popen3 as run

##############################################################################
## 
##
## Unix file type file content type recognition
##  - tests fmagic.py
## 
##
## 
############################################################################

def get_mimetype(fnm, len):


    cmd = 'head -c%d %s | /usr/bin/file -bi -' % (len, fnm)

    o, i, e = run(cmd)
    #print i, o, e
    err = e.readlines()
    if err:
        print 'err', err
    ft = o.readlines()[0].strip().split(';')[0].split(',')[0]

    return ft
    
############################################################################


def main():

    loadlen = 100

    magicfiles = "/usr/groups/nprobe/jch1003/tmp/file/file/file-4.09/magic/magic"
    magicfiles = '/usr/share/magic'

    fm = fmagic.fmagic(fmagic.MAGIC_MIME, magicfiles)

    for f in listdir('.'):
        if isfile(f):
            fo = open(f, 'rb')
            totread = fm.load_buffer(loadlen, fo.fileno())
            
            fmtype = fm.magic_own_buffer(totread).strip().split(';')[0].split(',')[0]
            filetype = get_mimetype(f, totread)
            print f, totread, fmtype, filetype
    
        
############################################################################


# Call main when run as script
if __name__ == '__main__':
        main()

        
