/*  -*- Mode: C;  -*- */

/******************************************************************************
*                                                                             *
*   Copyright 2005 University of Cambridge Computer Laboratory.               *
*                                                                             *
*   This file is part of Nprobe.                                              *
*                                                                             *
*   Nprobe is free software; you can redistribute it and/or modify            *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   Nprobe is distributed in the hope that it will be useful,                 *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Nprobe; if not, write to the Free Software                     *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
*                                                                             *
******************************************************************************/


%module fmagic



%{
#include "file.h"
#include "magic.h"
struct fmagic 
{
  magic_t *magic;
  void *buff;
  size_t bufflen;
};
%}

%include "magic.h"
struct fmagic 
{
  magic_t *magic;
  char *buff;
  size_t bufflen;
};

%addmethods fmagic {

/* Constructor */

fmagic(int flags, const char *magicfiles)
{
  struct fmagic *fp;
  magic_t *magic;
        
  if ((fp = (struct fmagic *)malloc(sizeof(struct fmagic))) == NULL)
    {
      fprintf(stderr, "pymod fmagic: init malloc error\n");
      exit(1);
    }

  fp->buff = NULL;
  fp->bufflen = 0;

  if ((fp->magic = magic_open(flags)) == NULL)
    {
      fprintf(stderr, "pymod fmagic: magic_open() error\n");
      exit(1);
    }

  if (magic_load(fp->magic, magicfiles) != 0)
    {
      fprintf(stderr, "pymod fmagic: magic_load() error\n");
      fprintf(stderr, "%s\n", magic_error(fp->magic));
      exit(1);
    }
  

  return fp;
}



char *
magic_file(const char *fnm)
  {
    const char *ret = magic_file(self->magic, fnm);
    if (ret == NULL)
      {
	fprintf(stderr, "pymod fmagic: magic_file() error\n");
	fprintf(stderr, "%s\n", magic_error(self->magic));
	exit(1);
      }

    return ret;
  }

char *
magic_buffer(char *buff, int len)
  {
    const char *ret = magic_buffer(self->magic, (const void *)buff, len);
    
    if (ret == NULL)
      {
	fprintf(stderr, "pymod fmagic: magic_buffer() error\n");
	fprintf(stderr, "%s\n", magic_error(self->magic));
	exit(1);
      }

    return ret;
  }

char *
magic_own_buffer(int len)
  {
    const char *ret = magic_buffer(self->magic, (const void *)self->buff, len);
    if (ret == NULL)
      {
	fprintf(stderr, "pymod fmagic: magic_buffer() error\n");
	fprintf(stderr, "%s\n", magic_error(self->magic));
	exit(1);
      }

    return ret;
  }

 int load_buffer(int len, int fd)
   {
     ssize_t nread, totread = 0;
     
     if (self->bufflen < len)
       {
	 free(self->buff);
	 if ((self->buff = (char *)malloc(len)) == NULL)
	   {
	     fprintf(stderr, "pymod fmagic: malloc buff() error\n");
	     exit(1);
	   }
	 self->bufflen = len;
       }

     while (totread < len)
       {
	 
	 nread = read(fd, self->buff+totread, len-totread);
	 if (nread == 0)
	   {
	     break;
	   }
	 else if (nread > 0)
	   {
	     totread += nread;
	   }
	 else
	   {
	     if (errno == EINTR)
	       {
		 continue;
	       }
	     else
	       {
		 fprintf(stderr, "pymod fmagic: read() error\n");
		 exit(1);
	       }
	   }
       }
     
     return totread;
   }
  
     

/*Destructor */
~fmagic() 
{
  magic_close(self->magic);
  free(self);
}

}; /* End addmethods fmagic */
