###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


#
# Some basic utility functions for manipulating UDP?DNS records in Nprobe logs
#

from nprobe import rrent, intoa_string, udp_conn, ns_fullrec
from  np_longutil import *

############################################################################# 

#
# Represents a DNS lookup seen in an nprobe record log
# - combines elements from UDP connection and NS record classes

class NSLookup:

    def __init__(self, client, connrec, nsrec):
	# conn is the UDP connection item, nsrec is the DNS query item

	def rrlist(rec):
	    # make a list of the RR items derived from the ns record's rrbuffer
	    l = []

	    ent = rrent()
	    indx = 0
	    #print 'index %d' % (indx)
	    indx = ent.nextent(indx, rec)
	    #print 'X add = %d' % (add)
	    #print 'X ent = '
	    #ent.printself()

	    while indx > 0:
		# only interested in IP_ADDR and CNAME lookups
		if ent.code < 50 and ent.code >= 0:
		    #print 'adding code %d' % (ent.code)
		    l.append(ent)
		    ent = rrent()
		#print 'index %d' % (indx)
		indx = ent.nextent(indx, rec)
		#print 'X add = %d' % (add)
		#print 'X ent = '
		#ent.printself()

	    
	    return l
	


	start = ull2l(connrec.open())
	self.client = client
	#self.server = conn.dhost()
	inner = nsrec.ns_rec
	self.absreqtm = start + ul2l(nsrec.ns_reqtm())
	self.absreptm =  start + ul2l(nsrec.ns_reptm())
        self.dur = self.absreptm - self.absreqtm
	if inner.state & 0x10:
	    self.rrlist = rrlist(nsrec)
	else:
	    self.rrlist = []

    def printself(self):
	print '%s ../.. %s' % (intoa_string(self.client), 
			       intoa_string(self.server))
	#self.nsrec.printself()
	for ent in self.rrlist:
	    ent.printself()
	print

#############################################################################

#
# Given a file lined up at the next UDP/DNS record return the record index, 
# UDP connection item, and DNS item

def get_ns_rec(file):
    connrec = udp_conn()
    nsrec = ns_fullrec()

    connrec.get_conn(file)
    nsrec.get_ns_rec(file)

    indx = connrec.indx

    return (indx, connrec, nsrec)

############################################################################# 
