###############################################################################
#                                                                             #
#   Copyright 2005 University of Cambridge Computer Laboratory.               #
#                                                                             #
#   This file is part of Nprobe.                                              #
#                                                                             #
#   Nprobe is free software; you can redistribute it and/or modify            #
#   it under the terms of the GNU General Public License as published by      #
#   the Free Software Foundation; either version 2 of the License, or         #
#   (at your option) any later version.                                       #
#                                                                             #
#   Nprobe is distributed in the hope that it will be useful,                 #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#   GNU General Public License for more details.                              #
#                                                                             #
#   You should have received a copy of the GNU General Public License         #
#   along with Nprobe; if not, write to the Free Software                     #
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                             #
###############################################################################


SA = 0
UA = 1


class AgentTypes:

    def __init__(self, logfn, n2rank):

        self.uad = {}
        self.sad = {}
        self.logfn = logfn
        self.n2rank = n2rank
        self.acode = 1


    def reg_b(self, bt, type):

        if type == UA:
            d = self.uad
        else:
            d = self.sad
            
        e = d.setdefault(bt, [0, 0])
        if not e[0]:
            e[0] = self.acode
            self.acode += 1
            
        e[1] += 1


    def order_by_freq(self, d):

        def by_1_1(a, b):
            return b[1][1] - a[1][1]

        l = d.items()
        l.sort(by_1_1)

        return l


    def rank(self, rank_str):

        ranks = [
            ['Server_types', self.sad],
            ['User_Agents', self.uad]
            ]

        for what, d in ranks:
            self.logfn('%d %s seen ' % (len(d), what))

            l = self.order_by_freq(d)

            for i in range(min(self.n2rank, len(l))):
                a = l[i]
                rank = rank_str(i)
                str = 'Rank %s %s %s (%d):' % (what, rank , a[0], a[1][1])
                self.logfn(str)
