
/* Generated by Interface Builder */


#import "Verse.h"
#import "Staff.h"
#import "GNote.h"
#import "System.h"
#import "GraphicView.h"
#import "GVFormat.h"
#import "DrawApp.h"
#import <AppKit/NSText.h>
#import <AppKit/NSFontManager.h>
/*#import <AppKit/nextstd.h>*/
#import <AppKit/publicWraps.h>
#import <Foundation/NSArray.h>
#import <strings.h>
#import "draw.h"
#import "mux.h"
#import "muxlow.h"

NSText *textObj;


@implementation Verse:Graphic


+ (void)initialize
{
  NSSize s;
  if (self == [Verse class])
  {
    [self setVersion: 3];		/* class version, see read: */
    if (!textObj)
    {
      textObj = [NSText new];
#warning PrintingConversion: May be able to remove some of the [textObj setXXXXMargin:] calls
      [textObj setLeftMargin:0.0];

      [textObj setRightMargin:0.0];

      [textObj setTopMargin:0.0];

      [textObj setBottomMargin:0.0];
#error ViewConversion: View's 'setOpaque:' is obsolete; you must override 'isOpaque' instead of setting externally (if sent to text, 'setDrawsBackground:' can be used to eliminate background gray; if sent to NSImageRep, it's OK)
      [textObj setOpaque:NO];
      s.width = 0.0;
      s.height = 0.0;
      [textObj setMinSize:s];
      s.width = 500.0;
      s.height = 500.0;
      [textObj setMaxSize:s];
      [textObj setVerticallyResizable:YES];
      [textObj setHorizontallyResizable:YES];
      [textObj setRichText:YES];
#error ViewConversion: '[NSView setFlipped:]' is obsolete; you must override 'isFlipped' instead of setting externally. However, [NSImage setFlipped:] is not obsolete. If that is what you are using here, no change is needed.
      [textObj setFlipped:YES];
      [textObj setSelColor:[NSColor whiteColor]];
      [textObj setTextColor:[NSColor blackColor]];
    }
  }
  return;
}


- init
{
  [super init];
  vFlags.hyphen = 0;
  font = [NSApp readyFont: [[NSFontManager new] selectedFont]];
  offset = 0;
  align = 0;
  data = NULL;
  note = nil;
  return self;
}


- (void)dealloc
{
  if (data) free(data);
  { [super dealloc]; return; };
}


/* override in case of blank verse */

- recalc
{
  float cx, bl;
  StaffObj *p = note;
  Staff *sp = p->mystaff;
  if (TYPEOF(sp) != STAFF) return self;
  if (data == NULL || *data == '\0') return self;
  bl = sp->y + baseline;
  cx = p->x - align + offset;
  bounds.origin.x = cx;
  bounds.origin.y = bl;
  return self;
}



/* for copying verse.  Caller must set the note and alignVerse and recalc */

- newFrom
{
  Verse *v = [[Verse alloc] init];
  v->vFlags = vFlags;
  v->gFlags = gFlags;
  v->font = font;
  v->offset = offset;
  v->data = malloc(strlen(data) + 1);
  strcpy(v->data, data);
  return v;
}


/* removeObj is sent by the client, who expects Verse to remove itself */

- removeObj
{
  [note unlinkverse: self];
  return [self release];
}


- (BOOL) isFigure
{
  unsigned char ch;
  unsigned char *p = data;
  if (p == NULL) return NO;
  while (ch = *p++) if (!figurechar(ch)) return NO;
  return YES;
}


- (BOOL) isContinuation
{
  unsigned char ch;
  unsigned char *p = data;
  if (p == NULL) return NO;
  ch = *p;
  return (ch == CONTHYPH || ch == CONTLINE);
}


/*
  Set the versebox caches.  The default alignment depends on the
  justification code (auto=0, left=1, right=2)
*/

/* return half significant width (up to first smile if any) and full width */

static void sigwidthpix(unsigned char *s, NSFont *f, float *sw, float *w)
{
  unsigned char c;
  BOOL sig = YES;
  float n = 0.0, sn = 0.0, cw;
  if (s != NULL) while (c = *s++)
  {
    if (c == TIECHAR) sig = NO;
    cw = charFWX(f, c);
    n += cw;
    if (sig) sn += cw;
  }
  *sw = sn * 0.5;
  *w = n;
}


/*
  set the align and pixlen field based on contents of the string.
  Alignment rule: using only the significant characters
  (those up to the first smile),
  align under first vowel or centre, whichever offset is smaller.
*/

- alignVerse
{
  float vw, hw;
  unsigned char *p, c;
  if (data == NULL)
  {
    align = 0;
    return self;
  }
  sigwidthpix(data, font, &hw, &pixlen);
  vw = 0.0;
  p = data;
  while (c = *p++)
  {
    if (c == TIECHAR) break;
    vw += charFGW(font, c);
    if (isvowel(c)) break;
  }
  align = MIN(vw, hw);
  return self;
}


- reShape
{
  return [self alignVerse];
}


/*
  Handle insertion/deletion from a verse.  Complication due to
  needing to redraw preceding hyphen if any, and also resetting
  figure time flags.
  0x80 is the Alt-Space key for inputting a baseline tie.
  If very first char, check it if a figure to set default font.
*/

- (int) keyDown: (int) cc : (int) cs
{
  int sl;
  StaffObj *p = nil;
  GNote *n = note;
  Verse *v;
  BOOL f = NO;
  if (cs == NX_ASCIISET)
  {
    if (cc == 0x80) cc = TIECHAR;
    if (data == NULL) sl = -1; else sl = strlen(data);
    if (cc == 127)
    {
      if (sl <= 0)
      {
        NSBeep();
        return 0;
      }
      data[sl - 1] = '\0';
      if (sl == 1)
      {
        f = YES;
	/* verse has been cleared */
	vFlags.hyphen = 0;
	offset = 0;
      }
    }
    else if (cc == HYPHCHAR) vFlags.hyphen = (vFlags.hyphen == 1) ? 0 : 1;
    else if (cc == '_') vFlags.hyphen = (vFlags.hyphen == 2) ? 0 : 2;
    else
    {
      f = YES;
      if (sl < 0)
      {
        data = (unsigned char *) malloc(2);
	data[0] = cc;
	data[1] = '\0';
      }
      else
      {
        data = (unsigned char *) realloc(data, sl + 2);
	data[sl] = cc;
	data[sl + 1] = '\0';
      }
      if (sl <= 0)
      {
        if ([self isFigure]) font = [[NSApp currentDocument] getPreferenceAsFont: FIGFONT];
	else font = [NSApp readyFont: [[NSFontManager new] selectedFont]];
      }
      if (cc == CONTHYPH) vFlags.hyphen = 1;
      else if (cc == CONTLINE) vFlags.hyphen = 2;
    }
  }
  [self reShape];
  [self recalc];
  if (f && TYPEOF(n->mystaff) == STAFF)
  {
    p = [n->mystaff prevVersed: n : vFlags.num];
    if (p != nil)
    {
      v = [p verseOf: vFlags.num];
      [[p myView] reDraw: v];
      [v recalc];
    }
  }
  return 1;
}



- (BOOL) hit: (NSPoint *) p
{
  return NSPointInRect(*p , bounds);
}



/*
  draw a repeated hyphen to fill space (add extra hyphen if fill to right end)
   just: 0 = centred, 1 = right just, 2 = left just, 3 = left and right just
*/

static void drawrepeat(float x1, float x2, float y, NSFont *f, int just, int m)
{
  int n;
  float inc, x, dx;
  dx = x2 - x1;
  n = ((int) ABS(dx)) / 64 + 1;
  inc = dx / (n + 1);
  x = x1;
  switch(just)
  {
    case 1:
      if (n > 1)
      {
        inc = dx / n;
        x = x1 - charFWX(f, HYPHCHAR);
      }
      break;
    case 2:
      if (n > 1)
      {  
        inc = dx / n;
        x = x1 - inc;
      }
      break;
    case 3:
      inc = dx / n;
      x = x1 - inc - charFWX(f, HYPHCHAR);
      ++n;
      break;
  }
  while (n--)
  {
    x += inc;
    centxChar(x, y, HYPHCHAR, f, m);
  }
}


/* draw an extender */

static void drawext(float x1, float y, float x2, Staff *sp, int f, int m)
{
  if (f)
  {
    x1 += 2;
    x2 -= 2;
  }
  if (x2 > x1) cline(x1, y, x2, y, 1.4 * staffthick[sp->flags.subtype][sp->flags.size], m);
}


/* return the left edge coordinate of a verse syllable */

- (float) textLeft: (StaffObj *) p
{
  return(p->x - align + offset);
}


/* display a whole line of continuation (hyphen or melisma) */

- drawContinuation: (int) ch : (float) x0 : (float) bl : (Staff *) sp : (int) m
{
  float x1 = [sp xOfEnd];
  if (ch == CONTHYPH) drawrepeat(x0, x1, bl, font, 3, m);
  else if (ch == CONTLINE) drawext(x0, bl, x1, sp, 0, m);
  return self;
}


/* display a figure below the y-line */

- drawFigure: (unsigned char *) s : (float) x : (float) y : (Staff *) sp : (int) m
{
  float fy, cx, cy, nlead, centoffy;
  unsigned char c, nc, a, ct[3];
  NSFont *f = font;
  NSFont *sf = musicFont[1][1];
  ct[1] = ct[2] = '\0';
  nlead = fontAscent(f);
  centoffy = 0.5 * charFGH(f, '3') - charFURY(f, '3');
  if (vFlags.above)
  {
    y -= figHeight(s, nlead) - nlead;
  }
  fy = y;
  while (c = *s++)
  {
    if (isedbrack(c))
    {
      /* do something here */
    
      /* do something here */
    }
    else if (c == '1')
    {
      ct[0] = c;
      if (*s != '\0') ct[1] = *s++;
      centString(x, fy, (char *) ct, f, m);
      fy += nlead;
      ct[1] = ct[2] = '\0';
    }
    else if (c == ' ')
    {
      fy += nlead;
    }
    else if (isaccident(c))
    {
      if (c == '!') a = SF_natural;
      else if (c == '@') a = SF_flat;
      else if (c == '#') a = SF_sharp;
      nc = *s;
      cy = fy + centoffy;
      if (nc == '3')
      {
        s++;
        cx = x;
        fy += nlead;
      }
      else if (nc == '\0')
      {
        cx = x;
	fy += nlead;
      }
      else cx = x - charFGW(f, *s);
      centxChar(cx, cy + charFCH(sf, a), a, sf, m);
    }
    else
    {
      centxChar(x, fy, c, f, m);
      fy += nlead;
    }
  }
  return self;
}


/*
  bl = sp->y + baseline;
  if ([self isFigure]) return [self drawFigure: data : p->x : bl : sp : m];
  cx = [self textLeft: p];
  [textObj getFrame: &fb];
  fb.origin.x = tx;
  fb.origin.y = ty - fb.size.height + [textObj descentLine];
  [textObj setFrame:&fb];
*/

- tryText: (char *) s : (float) tx : (float) ty
{
  NSRect tf;
  int length = strlen(s);
  NXStream *stream = NXOpenMemory(data, length, NX_READONLY);
#error TextConversion: 'replaceCharactersInRange:withRTF...' (used to be readRichText:) takes an NSData instance as its second argument. stream must be converted to NSData
  [textObj replaceCharactersInRange:NSMakeRange(0, [[textObj text] length]) withRTF:stream];
  tf = bounds;
  tf.origin.x = tx;
  tf.origin.y = ty - tf.size.height /* + [textObj descentLine] */;
  [textObj setFrame:tf];
#error ViewConversion: '-focusView' in NSApplication has been replaced by '+focusView' in NSView
  [[NSView focusView] addSubview: textObj];
  [textObj display];
  [textObj removeFromSuperview];
  NXCloseMemory(stream, NX_FREEBUFFER); /* was SAVE */
  return self;
}



- (BOOL)edit:(NSEvent *)event in:view
{
  id fe;
  NSSize maxSize;
  NSSize minSize;
  NXStream *stream;
  NSRect viewBounds;
  /* Get the field editor in this window. */
  [[view window] endEditingFor:self];
  fe = [[view window] fieldEditor:YES forObject:self];
  if (!fe) return NO;
  [fe setFont:[[NSFontManager new] selectedFont]];
  /* Show text ruler and abort hiding the ruler if recently ended editing. */
  [NSObject cancelPreviousPerformRequestsWithTarget:[self class] selector:@selector(hideRuler:) object:nil], [[self class] performSelector:@selector(hideRuler:) object:nil afterDelay:(0) / 1000.0];
  /* Modify it so that it will edit Rich Text and use the FontPanel. */
  [fe setCharFilter:NSEditorFilter];
  [fe setUsesFontPanel:YES];
  [fe setRichText:YES];
#error ViewConversion: View's 'setOpaque:' is obsolete; you must override 'isOpaque' instead of setting externally (if sent to text, 'setDrawsBackground:' can be used to eliminate background gray; if sent to NSImageRep, it's OK)
  [fe setOpaque:NO];
  viewBounds = [view bounds];
  maxSize.width = viewBounds.origin.x + viewBounds.size.width - bounds.origin.x;
  maxSize.height = viewBounds.origin.y + viewBounds.size.height - bounds.origin.y;
  minSize.width = minSize.height = [fe lineHeight];
  if (!bounds.size.height && !bounds.size.width) bounds.size = minSize;
  [fe setMinSize:minSize];
  [fe setMaxSize:maxSize];
  [fe setFrame:bounds];
  [fe setVerticallyResizable:YES];
  [fe setHorizontallyResizable:YES];
  if (data)
  {
    stream = NXOpenMemory(data, length, NX_READONLY);
#error TextConversion: 'replaceCharactersInRange:withRTF...' (used to be readRichText:) takes an NSData instance as its second argument. stream must be converted to NSData
    [fe replaceCharactersInRange:NSMakeRange(0, [[fe text] length]) withRTF:stream];
    NXCloseMemory(stream, NX_FREEBUFFER); /* was SAVE */
  }
  else
  {
    [fe setString:@""];
    [fe setAlignment:NSLeftTextAlignment];
    [fe setSelColor:[NSColor whiteColor]];
    [fe setTextColor:[NSColor blackColor]];
    [fe setFont:fontdata[FONTTEXT]];
    [fe unscript:self];
  }
  /*
   * Add the Text object to the view hierarchy and set self as its delegate
   * so that we will receive the textDidEnd:endChar: message when editing
   * is finished.
  */
  [fe setDelegate:self];
  [view addSubview:fe];
  /*
   * Make it the first responder.
  */
  [[view window] makeFirstResponder:fe];
  /* Change the ruler to be a text ruler. */
  [fe tryToPerform:@selector(showTextRuler:) with:fe];
  /*
   * Either pass the mouse-down event on to the Text object, or set
   * the selection at the beginning of the text.
  */
  if (event)
  {
    [fe selectNull];	/* eliminates any existing selection */
    [fe mouseDown:event];
  } 
  else [fe setSelectionStart:0 end:0];
  return YES;
}


/* Text object delegate methods */

- (NSRect)textDidResize:(NSCStringText *)fe oldBounds:(NSRect)o
{
  
    NSRect i;
    bounds = [fe frame];
  return i;
}


/*
 * This method is called when ever first responder is taken away from a
 * currently editing TextGraphic (i.e. when the user is done editing and
 * chooses to go do something else).  We must extract the rich text the user
 * has typed from the Text object, and store it away.  We also need to
 * get the frame of the Text object and make that our bounds
   If the Text object is empty, then we remove
 * this TextGraphic from the GraphicView and delayedFree: it.
 * We must remove the Text object from the view hierarchy and, since
 * this Text object is going to be reused, we must set its delegate
 * back to nil.
 */

#warning NotificationConversion: 'textDidEndEditing:' used to be 'textDidEnd:'.  This conversion assumes this method is implemented or sent to a delegate of NSText.  If this method was implemented by a NSMatrix or NSTextField textDelegate, use the text notifications in NSControl.h.
- (void)textDidEndEditing:(NSNotification *)notification
{
#warning NotificationConversion: if this notification was not posted by NSText (eg. was forwarded by NSMatrix or NSTextField from the field editor to their textDelegate), then the text object is found by [[notification userInfo] objectForKey:@"NSFieldEditor"] rather than [notification object]
  NSText *theText = [notification object];
    int endChar = [[[notification userInfo] objectForKey:@"NSTextMovement"] intValue];
    int maxlen, k;
  char *buffer;
  NXStream *stream;
  NSRect oldBounds;
  GraphicView  *v;
  if (data)
  {
    free(data);
    data = NULL;
  }
  oldBounds = bounds;
  v = [theText superview];
  k = [[theText text] length];
  if (!k)
  {
    [v deselectObj: self];
    [self unlinkObj];
  }
  else
  {
    /* ought to first check if any edits were made.  Is there a method for this? */
    stream = NXOpenMemory(NULL, 0, NX_WRITEONLY);
#error TextConversion: RTFFromRange: (used to be writeRichText:stream) returns an NSData instance (used to write contents to <steeam>). stream must be converted to NSData
    stream = [theText RTFFromRange:NSMakeRange(0, [[theText text] length])];
    NXGetMemoryBuffer(stream, &buffer, &length, &maxlen);
    data = malloc(length);
    bcopy(buffer, data, length);
    NXCloseMemory(stream, NX_FREEBUFFER);
    bounds = [theText frame];
    oldBounds  = NSUnionRect(bounds , oldBounds);
  } 
  [v cache:&oldBounds];
  [[v window] flushWindow];
  [v dirty];
  [NSObject cancelPreviousPerformRequestsWithTarget:[self class] selector:@selector(hideRuler:) object:v], [[self class] performSelector:@selector(hideRuler:) object:v afterDelay:(500) / 1000.0];
  [theText removeFromSuperview];
  [theText setDelegate:nil];
  [theText setSelectionStart:0 end:0];
  if (!k) [self autorelease];
}


/*
  Draw the Ith verse of a staff object as the Jth line.
*/

- drawMode: (int) m
{
  int h;
  float bl, cx, ex, mx;
  System *sys;
  StaffObj *q;
  StaffObj *p = note;
  Staff *sp = p->mystaff;
  if (TYPEOF(sp) != STAFF) return self;
  if (m && p->gFlags.selected && !p->gFlags.seldrag && p->selver == vFlags.num) [self traceBounds];
  if (data == NULL || *data == '\0') return self;
  bl = sp->y + baseline;
  if ([self isFigure]) return [self drawFigure: data : p->x : bl : sp : m];
  if ([self isContinuation]) return [self drawContinuation: *data : p->x : bl : sp : m];
  cx = [self textLeft: p];
  [self tryText: (char *) data : cx : bl];
  if (![sp textedBefore: p : vFlags.num])
  {
    sys = sp->mysys;
    h = [sys->view prevHyphened: sys : [sp myIndex] : vFlags.num];
    if (h == 1)
    {
      ex = [sp firstTimedBefore: p];
      mx = 2.0 * charFGW(font, HYPHCHAR);
      if (cx - ex < mx) centxChar(cx - mx, bl, HYPHCHAR, font, m);
      else drawrepeat(ex, cx, bl, font, 2, m);
    }
    else if (h == 2 && [sp vocalBefore: p : vFlags.num])
    {
      ex = [sp xOfHyphmarg];
      mx = [sp endMelisma: [sp getNote: 0] : vFlags.num];
      drawext(ex, bl, mx, sp, 1, m);
    }
  }
  if (vFlags.hyphen == 1)
  {
    q = [sp nextVersed: p : vFlags.num];
    if (q == nil)
    {
      drawrepeat(cx + pixlen, [sp xOfEnd], bl, font, 1, m);
    }
    else
    {
      drawrepeat(cx + pixlen, [[q verseOf: vFlags.num] textLeft: q], bl, font, 0, m);
    }
  }
  else if (vFlags.hyphen == 2)
  {
    ex = [sp endMelisma: p : vFlags.num];
    drawext(cx + pixlen, bl, ex, sp, 1, m);
  }
  return self;
}


/*
  Assumes that verses are never invisible.  Figures might have invisible notes
*/

- draw
{
  return [self drawMode: drawmode[((Graphic *)note)->gFlags.selected][0]];
}


/*
  Version 1 archives fonts the AppKit way, but still uses fids
*/


#error ArchiverConversion: put the contents of your 'awake' method at the end of your 'initWithCoder:' method instead
- awake
{
  int maxlen, length;
  char *buffer;
  NXStream *stream;
  NSSize maxSize;
  [textObj setString:[NSString stringWithCString:data]];
  [textObj setFont:font];
  [textObj setRichText:YES];
  /*
  [textObj calcLine];
  [textObj sizeToFit];
  */
  stream = NXOpenMemory(NULL, 0, NX_WRITEONLY);
#error TextConversion: RTFFromRange: (used to be writeRichText:stream) returns an NSData instance (used to write contents to <steeam>). stream must be converted to NSData
  stream = [textObj RTFFromRange:NSMakeRange(0, [[textObj text] length])];
  NXGetMemoryBuffer(stream, &buffer, &length, &maxlen);
  if (data) free(data);
  data = malloc(length+1);
  bcopy(buffer, data, length);
  data[length] = '\0';
  NXCloseMemory(stream, NX_FREEBUFFER);
  return self;
}



struct oldflags		/* for old versions */
{
  unsigned int hyphen : 2;	/* type of hyphen */
  unsigned int line : 3;	/* actual line */
  unsigned int num : 3;		/* verse number */
};


- (id)initWithCoder:(NSCoder *)aDecoder
{
  short len, flen;
  float fs;
  char fn[64];
  struct oldflags ff;
  char b1, b2, b3;
  int v = [aDecoder versionForClassName:@"Verse"];
  [super initWithCoder:aDecoder];
  /* fprintf(stderr, "reading Verse v%d\n", v); */
  if (v == 0)
  {
    [aDecoder decodeValuesOfObjCTypes:"sssccff", &ff, &len, &flen, &offset, &align, &fs, &pixlen];
    vFlags.hyphen = ff.hyphen;
    vFlags.line = ff.line;
    vFlags.num = ff.num;
    data = malloc(len + 1);
    [aDecoder decodeArrayOfObjCType:"c" count:len at:data];
    data[len] = '\0';
    [aDecoder decodeArrayOfObjCType:"c" count:flen at:fn];
    fn[flen] = '\0';
    font = [NSApp readyFont: fn : fs];
    note = [[aDecoder decodeObject] retain];
  }
  else if (v == 1)
  {
    [aDecoder decodeValuesOfObjCTypes:"@@fscc*", &font, &note, &pixlen, &ff, &offset, &align, &data];
    vFlags.hyphen = ff.hyphen;
    vFlags.line = ff.line;
    vFlags.num = ff.num;
    [NSApp readyFont: font];
  }
  else if (v == 2)
  {
    [aDecoder decodeValuesOfObjCTypes:"@@fcc*", &font, &note, &pixlen, &offset, &align, &data];
    [aDecoder decodeValuesOfObjCTypes:"ccc", &b1, &b2, &b3];
    vFlags.hyphen = b1;
    vFlags.line = b2;
    vFlags.num = b3;
    [NSApp readyFont: font];
  }
  else if (v == 3)
  {
    [aDecoder decodeValuesOfObjCTypes:"@@ffcc*", &font, &note, &pixlen, &baseline, &offset, &align, &data];
    [aDecoder decodeValuesOfObjCTypes:"ccc", &b1, &b2, &b3];
    vFlags.hyphen = b1;
    vFlags.line = b2;
    vFlags.num = b3;
    [NSApp readyFont: font];
  }
  return self;
}


- (void)encodeWithCoder:(NSCoder *)aCoder
{
  char b1, b2, b3;
  [super encodeWithCoder:aCoder];
  [aCoder encodeValuesOfObjCTypes:"@@ffcc*", &font, &note, &pixlen, &baseline, &offset, &align, &data];
  b1 = vFlags.hyphen;
  b2 = vFlags.line;
  b3 = vFlags.num;
  [aCoder encodeValuesOfObjCTypes:"ccc", &b1, &b2, &b3];
}


@end
