
/* Generated by Interface Builder */

#import "ToneTool.h"
#import "GNote.h"
#import "GraphicView.h"
#import "GVSelection.h"
#import "DrawApp.h"
#import "DrawDocument.h"
#import "mux.h"
#import "muxlow.h"
#import <AppKit/NSMatrix.h>
#import <Foundation/NSArray.h>

@implementation ToneTool


/* set General MIDI Tone */

- setTone: sender
{
  GNote *p;
  int i, k;
  GraphicView *v;
  DrawDocument *d;
  NSMutableArray *sl;
  d = [NSApp currentDocument];
  if (d == nil) return self;
  v = [d view];
  if (v == nil) return self;
  sl = v->slist;
  i = 8 * [sender selectedRow] + [sender selectedColumn];
  k = [sl count];
  while (k--)
  {
    p = [sl objectAtIndex:k];
    if (TYPEOF(p) == NOTE) p->instrument = i + 1;
  }
  [v dirty];
  [NSApp inspectApp];
  return self;
}


- preset
{
  int mult, i, k, pat;
  DrawDocument *d;
  GraphicView *v;
  NSMutableArray *sl;
  GNote *p;
  d = [NSApp currentDocument];
  if (d == nil) return self;
  v = [d view];
  if (v == nil) return self;
  sl = v->slist;
  k = [sl count];
  i = -1;
  mult = 0;
  while (k--)
  {
    p = [sl objectAtIndex:k];
    if (TYPEOF(p) == NOTE && p->instrument)
    {
      pat = p->instrument - 1;
      if (i == -1) i = pat;
      else if (i != pat) mult = 1;
    }
  }
  if (i == -1 || mult) clearMatrix(tonematrix);
  else [tonematrix selectCellAtRow:(i >> 3) column:(i & 7)];
  return self;
}


@end
