#if 0
#import <Foundation/Foundation.h>

int main (int argc, const char *argv[])
{
   NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];

   // insert your code here

   [pool release];
   exit(0);       // insure the process exit status is 0
   return 0;      // ...and make main fit the ANSI spec.
}

#endif


// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

// See the README for background and usage of Launcher.

// Turn off OBASSERT, since it relies on code in OmniBase, and we don't actually link against OmniBase (otherwise we'd need ourselves to launch)
// hacked very slightly by sbrandon, for OpenStep4.2 path names etc.

#define OMNIMAKE_FORCE_ASSERTIONS_OFF
//following commented out by sbrandon:
//#import <OmniBase/rcsid.h>
//#import <OmniBase/assertions.h>
//... and assertions taken care of...
   #define OBASSERT(expression)

#import <unistd.h>
#import <stdlib.h>
#import <string.h>
#import <sys/param.h>
#import <stdio.h>
#import <stdlib.h>

//RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Applications/Launcher/Launcher.c,v 1.2 2000/06/02 17:42:55 kc Exp $");

extern char **environ;

//sb:
#if (i386 && !WIN32) || m68k
#define DEFAULT_SYSTEM_FRAMEWORK_PATH "/LocalLibrary/Frameworks:/NextLibrary/Frameworks"
#else
#define DEFAULT_SYSTEM_FRAMEWORK_PATH "/Local/Library/Frameworks:/Network/Library/Frameworks:/System/Library/Frameworks"
#endif

int main(int argc, const char *argv[]) {
   char *currentFrameworkPath;
   char newFrameworkPath[8192];
   const char *pathToLauncherBinary;
   const char *pointerToFinalSlashInPathToLauncherBinary;
   char pathToLauncherAppWrapper[MAXPATHLEN];
   char pathToRealApplicationBinary[MAXPATHLEN];
   const char *applicationName;

   // Note:  Yes, this code would be cleaner in Objective C.  However, that would mean we'd have to start up the Objective C run-time, and since we're just going to terminate as soon as possible we really don't want this to take longer than necessary.  (Also, the Objective C run-time probably has some side effects with respect to our mach ports which we don't want to trigger.)

   // The path to the launcher binary (that's us, dude!) is in argv[0]
   OBASSERT(argc > 0);
   pathToLauncherBinary = argv[0];

   // Calculate the application name and the path to its wrapper
   pointerToFinalSlashInPathToLauncherBinary = rindex(pathToLauncherBinary, '/');
   if (!pointerToFinalSlashInPathToLauncherBinary) {
       // No slashes in the path to the launcher binary

       // Our application name is simply the path
       applicationName = pathToLauncherBinary;

       // Our wrapper had better be the current working directory.
       getwd(pathToLauncherAppWrapper);
   } else {
       // Our application name follows that final slash
       applicationName = pointerToFinalSlashInPathToLauncherBinary + 1;

       // The (possibly relative) path to the app wrapper is everything up to that final slash
       strcpy(pathToLauncherAppWrapper, pathToLauncherBinary);
       pathToLauncherAppWrapper[pointerToFinalSlashInPathToLauncherBinary - pathToLauncherBinary] = '\0'; // truncate at the final slash

       if (pathToLauncherAppWrapper[0] == '/') {
           // The app wrapper path is already an absolute path, just use it
       } else {
           char originalWorkingDirectory[MAXPATHLEN];

           // Turn the app wrapper path into a relative path.  This would sure be easy with NSString's path utilities, but...

           // Save the original working directory
           getwd(originalWorkingDirectory);
           // chdir() accepts relative paths
           chdir(pathToLauncherAppWrapper);
           // and getwd() returns absolute paths
           getwd(pathToLauncherAppWrapper);
           // Restore the original working directory
           chdir(originalWorkingDirectory);
       }
   }
   // We've now calculated our application name, and the absolute path to our app wrapper's Contents/MacOS directory
//sb: that's the app name, and the absolute path of the folder named /.../MyApp.app/

   OBASSERT(applicationName != NULL && applicationName[0] != '\0');
   OBASSERT(pathToLauncherAppWrapper[0] == '/');

   // Create a new framework path, so it will search for frameworks within our app wrapper before it looks for them anywhere else.

   // Start with the path to our app wrapper's ContentsFrameworks subdirectory
#if (i386 && !WIN32) || m68k
   sprintf(newFrameworkPath, "%s/Resources", pathToLauncherAppWrapper);
#else
   sprintf(newFrameworkPath, "%s/../Frameworks", pathToLauncherAppWrapper);
#endif

   strcat(newFrameworkPath, ":");

   // Append the standard framework path
   if ((currentFrameworkPath = getenv("DYLD_FRAMEWORK_PATH"))) {
       // There's already a framework path, append it to the new path
       strcat(newFrameworkPath, currentFrameworkPath);
   } else {
       const char *homeDirectory;

       // There's no framework path currently set, so we should append the standard framework path

       // Append $HOME/Library/Frameworks to the path
       if ((homeDirectory = getenv("HOME"))) {
           strcat(newFrameworkPath, homeDirectory);
           strcat(newFrameworkPath, "/Library/Frameworks:");
       }

       // Append the default system framework path to the new path
       strcat(newFrameworkPath, DEFAULT_SYSTEM_FRAMEWORK_PATH);
   }

   // Set the DYLD_FRAMEWORK_PATH environment variable to use our new path
//sb: openStep4.2 does not have setenv!
#if !((i386 && !WIN32) || m68k)
   setenv("DYLD_FRAMEWORK_PATH", newFrameworkPath, 1);
#endif
   // Launch the real application

   // It should live right next to us
   sprintf(pathToRealApplicationBinary, "%s/.%s", pathToLauncherAppWrapper, applicationName);

   // Let the user know what we're doing (or not)
   // fprintf(stderr, "Launching %s...\n", pathToRealApplicationBinary);

   // Execute the real application.  If successful, this call does not return.  (It doesn't fork off a process, it launches the other application in place of the current application within the current process.)
#if !((i386 && !WIN32) || m68k)
   execve(pathToRealApplicationBinary, argv, environ);
#else
//need to:
//create array of char* pointers (how many?)
// copy into it from "environ" all pointers that are not equal to "DYLD_FRAMEWORK_PATH"
// add new one to end, with our (formatted) DYLD_FRAMEWORK_PATH=foo in it.
// do the execve.
   {
       int i = 0, j = 0, count=0;
       char** env2;
       char newenv[MAXPATHLEN+21];
       sprintf(newenv,"DYLD_FRAMEWORK_PATH=%s",newFrameworkPath);

       while (environ[count++]);
       env2=malloc((count + 2) * sizeof(char*));
       while (environ[i]) {
           /*not equal*/
           if (strncmp("DYLD_FRAMEWORK_PATH=",environ[i],20)) {
               env2[j] = environ[i]; j++;
           }
           i++;
       }
       env2[j] = newenv;
       env2[j+1] = NULL;
       execve(pathToRealApplicationBinary, argv, env2);
   }
#endif

   // This code does not get called in normal operation:  if execve() succeeds, it doesn't return, so in this case execve() must have failed.

   // Print the error message associated with the current error condition
   perror(pathToRealApplicationBinary);

   // Return an error status.
   return 1;
}
