
/* Generated by Interface Builder */

#import "CallPart.h"
#import "CallInst.h"
#import <AppKit/AppKit.h>

@implementation NSMutableArray(PartCell)

extern NSString *nullInstrument;
extern NSString *nullPart;


- (NSString *) partNameForInt: (int) i
{
  if (i < 0) return nullPart;
  if (i >= [self count]) return nullPart;
  return ((CallPart *)[self objectAtIndex:i])->name;
}

- (NSString *) instrumentForPart: (NSString *) p
{
  int k = [self count];
  CallPart *cp;
  while (k--)
  {
    cp = [self objectAtIndex:k];
      if ([cp->name isEqualToString: p]) return cp->instrument;
  }
  return nullInstrument;
}


- (int) channelForPart: (NSString *) p
{
  int k = [self count];
  CallPart *cp;
  while (k--)
  {
    cp = [self objectAtIndex:k];
      if ([cp->name isEqualToString: p]) return cp->channel;
  }
  return 1;
}


- (CallPart *) partNamed: (NSString *) p
{
  int k = [self count];
  CallPart *cp;
  while (k--)
  {
    cp = [self objectAtIndex:k];
      if ([cp->name isEqualToString: p]) return cp;
  }
  return nil;
}


- (int) indexOfPartName: (NSString *) p
{
  int k = [self count];
  CallPart *cp;
  while (k--)
  {
    cp = [self objectAtIndex:k];
      if ([cp->name isEqualToString: p]) return k;
  }
  return -1;
}

/*
  The sort is required to be fastest when elements are in order. Shellsort.
*/

#define STRIDE_FACTOR 3

- sortPartlist /*sb: when we change to NSArray instad of List, we can do away with this. */
{
  int c, d, f, s, k;
  CallPart *p;
  k = [self count];
  s = 1;
  while (s <= k) s = s * STRIDE_FACTOR + 1;
  while (s > (STRIDE_FACTOR - 1))
  {
    s = s / STRIDE_FACTOR;
    for (c = s; c < k; c++)
    {
      f = NO;
      d = c - s;
      while ((d >= 0) && !f)
      {
//        if (strcmp(((CallPart *)[self objectAt: d + s])->name, ((CallPart *)[self objectAt: d])->name) < 0)
          if ([((CallPart *)[self objectAtIndex:d + s])->name compare:((CallPart *)[self objectAtIndex:d])->name] == NSOrderedAscending)
	{
              p = [[self objectAtIndex:d] retain];//sb: retain cos it's gonna be removed from array
	  [self replaceObjectAtIndex:d withObject:[self objectAtIndex:d + s]];
	  [self replaceObjectAtIndex:d + s withObject:p];
          [p release];
	  d -= s;
	}
	else f = YES;
      }
    }
  }
  return self;
}


@end



@implementation CallPart:NSObject


+ (void)initialize
{
  if (self == [CallPart class])
  {
      (void)[CallPart setVersion: 2];	/* class version, see read: */ /*sb: bumped up to 2 for OS conversion */
  }
  return;
}


- init: (NSString *) n : (NSString *) a : (int) ch : (NSString *) i /* sb: n and a were char*, i was NXAtom */
{
  [super init];
//  name = NXUniqueString(n);
    name = [[NSString stringWithString:n] retain];
//  if (a == NULL) abbrev = NULL; else abbrev = NXCopyStringBuffer(a);
    if (a) abbrev = [a retain];
    else {
        if (abbrev) [abbrev release];
        abbrev=nil;
    }
  channel = ch;
  instrument = [i retain];
  return self;
}

- update:  (NSString *) n : (NSString *) a : (int) ch : (NSString *) i /* sb: n and a were char*, i was NXAtom */
{
    [name autorelease];
    name = [n retain];
    if (abbrev)
      {
        if (a) {
            if (![a isEqualToString:abbrev]) {
                [abbrev autorelease];
                abbrev = [a retain];
            }
        } else {
            [abbrev autorelease];
            abbrev = nil;
        }
      } else abbrev = [a retain];
            
/*
    if (strcmp(a, abbrev))
    {
      free(abbrev);
      abbrev = ((a == NULL) ? NULL : NXCopyStringBuffer(a));
    }
  }
  else abbrev = ((a == NULL) ? NULL : NXCopyStringBuffer(a));
 */
    channel = ch;
  instrument = i;
  return self;
}


- (CallPart *) newFrom
{
  return [[CallPart alloc] init: name : abbrev : channel : instrument];
}


- (void)dealloc
{
    if (name) [abbrev release];
    if (instrument) [abbrev release];
    if (abbrev) [abbrev release];
    [super dealloc];
}

extern int needUpgrade;

- (id)initWithCoder:(NSCoder *)aDecoder
{
  int v;
    char *n,*a,*i;//sb: to decode NSAtoms and char *'s
  v = [aDecoder versionForClassName:@"CallPart"];
  if (v == 0)
  {
      [aDecoder decodeValuesOfObjCTypes:"**ii", &n, &a, &instrument, &channel];
      if (n) name = [[NSString stringWithCString:n] retain]; else name = nil;
      if (a) abbrev = [[NSString stringWithCString:a] retain]; else abbrev = nil;
    needUpgrade |= 8;
  }
  else if (v == 1)
  {
      [aDecoder decodeValuesOfObjCTypes:"%*%i", &n, &a, &i, &channel];
      if (n) name = [[NSString stringWithCString:n] retain]; else name = nil;
      if (a) abbrev = [[NSString stringWithCString:a] retain]; else abbrev = nil;
      if (i) instrument = [[NSString stringWithCString:i] retain]; else instrument = nil;
  }
  else if (v == 2)
    {
      [aDecoder decodeValuesOfObjCTypes:"@@@i", &name, &abbrev, &instrument, &channel];
    }

  return self;
}


- (void)encodeWithCoder:(NSCoder *)aCoder
{
    [aCoder encodeValuesOfObjCTypes:"@@@i", &name, &abbrev, &instrument, &channel];
}

- (void)encodeWithPropertyListCoder:(OAPropertyListCoder *)aCoder
{
    [aCoder setString:name forKey:@"name"];
    [aCoder setString:abbrev forKey:@"abbrev"];
    [aCoder setString:instrument forKey:@"instrument"];
    [aCoder setInteger:channel forKey:@"channel"];
}


@end
