
/* Generated by Interface Builder */

#import "BrackInspector.h"
#import "Bracket.h"
#import "DrawApp.h"
#import "DrawDocument.h"
#import "GraphicView.h"
#import "GVSelection.h"
#import "System.h"
#import "Staff.h"
#import "mux.h"
#import <AppKit/NSMatrix.h>
#import <AppKit/NSButton.h>

#import <Foundation/NSArray.h>


@implementation BrackInspector


- setProto: sender
{
  Bracket *p = [Bracket myPrototype];
  p->gFlags.subtype = 2 - [typematrix selectedColumn];
  p->level = 3 - [levelmatrix selectedColumn];
  return self;
}


/*
  called when the SET button is pushed.
  Here the complication is to change the meaning of the client
  if changing to/from a LINKAGE.  Also the buttons are backwards,
  hence the subtractions.
*/

- set:sender
{
  NSRect b;
  Bracket *p;
  System *s;
  id sl, v = [[NSApp currentDocument] gview];
  int k, t;
  BOOL ok;
  if ([v startInspection: BRACKET : &b : &sl])
  {
    k = [sl count];
    while (k--) if ((p = [sl objectAtIndex:k]) && TYPEOF(p) == BRACKET)
    {
      t = 2 - [typematrix selectedColumn];
      s = [p mySystem];
      ok = YES;
      if (SUBTYPEOF(p) == LINKAGE && t != LINKAGE)
      {
        p->client1 = p->client2 = [s firststaff];	
      }
      else if (SUBTYPEOF(p) != LINKAGE && t == LINKAGE)
      {
        if ([s hasLinkage]) ok = NO;
	else
	{
          p->client1 = s;
	  p->client2 = nil;
	}
      }
      if (!ok) NSBeep();
      else
      {
        p->gFlags.subtype = 2 - [typematrix selectedColumn];
        p->level = 3 - [levelmatrix selectedColumn];
        [p recalc];
      }
    }
    [v endInspection: &b];
  }
  return self;
}


/*
  Called when panel is opened.
*/

- preset
{
  Bracket *p = [[[NSApp currentDocument] gview] canInspect: BRACKET];
  if (p != nil)
  {
    [typematrix selectCellAtRow:0 column:2 - p->gFlags.subtype];
    [levelmatrix selectCellAtRow:0 column:3 - p->level];
  }
  return self;
}


- presetTo: (int) i
{
  Bracket *p = [Bracket myPrototype];
  [typematrix selectCellAtRow:0 column:2 - p->gFlags.subtype];
  [levelmatrix selectCellAtRow:0 column:3 - p->level];
  return self;
}

@end
