/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import opera.PluginClassLoader;
import opera.PluginContextManager;
import opera.PluginPanel;
import opera.StreamHandlerFactory;

public class PluginContext
implements AppletContext {
    private static String clipImplName;
    protected static Object opera_mutex;
    private HashSet panels = new HashSet();
    private Hashtable audioCache = new Hashtable();
    private Hashtable imageCache = new Hashtable();
    protected int document_ptr = 0;
    protected int lf_document_ptr = 0;
    private PluginClassLoader loader = null;

    protected PluginContext(int n) {
        this.document_ptr = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Applet getApplet(String string) {
        Iterator iterator;
        string = string.toLowerCase();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            iterator = this.panels.iterator();
        }
        while (iterator.hasNext()) {
            PluginPanel pluginPanel = (PluginPanel)iterator.next();
            String string2 = pluginPanel.getParameter("name");
            if (string2 != null) {
                string2 = string2.toLowerCase();
            }
            if (!string.equals(string2)) continue;
            return pluginPanel.getApplet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration getApplets() {
        Iterator iterator;
        Vector<Applet> vector = new Vector<Applet>();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            iterator = this.panels.iterator();
        }
        while (iterator.hasNext()) {
            vector.addElement(((PluginPanel)iterator.next()).getApplet());
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(URL uRL) {
        PluginContext.checkConnect(uRL);
        Hashtable hashtable = this.audioCache;
        synchronized (hashtable) {
            Object object;
            AudioClip audioClip = (AudioClip)this.audioCache.get(uRL);
            if (audioClip == null) {
                try {
                    object = Class.forName(clipImplName);
                    Class[] classArray = new Class[]{Class.forName("java.net.URL")};
                    Object[] objectArray = new Object[]{uRL};
                    Constructor constructor = ((Class)object).getConstructor(classArray);
                    audioClip = (AudioClip)constructor.newInstance(objectArray);
                    this.audioCache.put(uRL, audioClip);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            object = audioClip;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL uRL) {
        Hashtable hashtable = this.imageCache;
        synchronized (hashtable) {
            Image image = (Image)this.imageCache.get(uRL);
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                this.imageCache.put(uRL, image);
            }
            Image image2 = image;
            return image2;
        }
    }

    public void showDocument(URL uRL) {
        this.showDocument(uRL, "_top");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDocument(URL uRL, String string) {
        Object object = opera_mutex;
        synchronized (object) {
            String string2 = uRL.toString();
            this.showDocument(string2, string);
        }
    }

    private native void showDocument(String var1, String var2);

    public native void showStatus(String var1);

    public void setStream(String string, InputStream inputStream) throws IOException {
    }

    public InputStream getStream(String string) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    public static void init(String[] stringArray) throws SecurityException {
        Object object;
        Object object2;
        try {
            object2 = Class.forName("sun.plugin.security.JDK11ClassFileTransformer");
            object = ((Class)object2).getMethod("init", null);
            ((Method)object).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = new SecurityManager();
        System.setSecurityManager((SecurityManager)object2);
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(new AllPermission());
        }
        int n = 0;
        while (n < stringArray.length / 2) {
            System.setProperty(stringArray[n * 2], stringArray[n * 2 + 1]);
            ++n;
        }
        if (System.getProperty("browser.opera.useStreamHandler").equals("true")) {
            URL.setURLStreamHandlerFactory(new StreamHandlerFactory());
        }
        clipImplName = System.getProperty("browser.opera.audioClipClassName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginPanel newPanel(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, int n) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n2 = 0;
            while (n2 < stringArray3.length) {
                hashtable.put(stringArray3[n2].toLowerCase(), stringArray4[n2]);
                ++n2;
            }
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                hashtable2.put(stringArray[n3].toLowerCase(), stringArray2[n3]);
                ++n3;
            }
            PluginPanel pluginPanel = new PluginPanel(this, hashtable2, hashtable, new URL(string), n);
            HashSet hashSet = this.panels;
            synchronized (hashSet) {
                this.panels.add(pluginPanel);
                PluginPanel pluginPanel2 = pluginPanel;
                return pluginPanel2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    void destroyPanel(PluginPanel pluginPanel) {
        try {
            if (pluginPanel != null) {
                Frame frame = (Frame)pluginPanel.getParent();
                if (frame != null) {
                    frame.removeAll();
                    frame.dispose();
                }
                pluginPanel.destroyApplet();
                this.panels.remove(pluginPanel);
            }
            if (this.panels.size() == 0) {
                PluginContextManager.deleteContext(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public native int getJSWindow();

    public native int getESRuntime();

    private static void checkConnect(URL uRL) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    securityManager.checkPermission(permission);
                } else {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            catch (IOException iOException) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
        }
    }

    protected void setClassLoader(PluginClassLoader pluginClassLoader) {
        if (this.loader == null) {
            this.loader = pluginClassLoader;
        }
    }

    protected void cleanup() {
        if (this.loader != null) {
            ThreadGroup threadGroup = this.loader.getThreadGroup();
            this.loader = null;
        }
    }

    public int getDocumentPtr() {
        return this.document_ptr;
    }

    private void documentDeleted() {
        this.lf_document_ptr = this.document_ptr;
        this.document_ptr = 0;
    }

    protected void setDocumentPtr(int n) {
        this.document_ptr = n;
    }

    protected void setLoadingFinished(int n) {
        if ((this.document_ptr != 0 || this.lf_document_ptr != 0) && n != 0) {
            this.nativeSetLoadingFinished(this.document_ptr == 0 ? this.lf_document_ptr : this.document_ptr, n);
        }
    }

    private native void nativeSetLoadingFinished(int var1, int var2);

    static {
        opera_mutex = new Object();
    }
}

