/*
 * Decompiled with CFR 0.152.
 */
package opera;

import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import opera.LiveConnectProtectionDomain;
import opera.OriginNotAllowedException;
import opera.PrivilegedGetField;
import opera.PrivilegedInvoke;
import opera.PrivilegedNewObject;
import opera.PrivilegedSetField;

public class LiveConnectPrivilegedActions {
    public static Object newObject(Constructor constructor, Object[] objectArray, String string) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, constructor.getDeclaringClass());
        return AccessController.doPrivileged(new PrivilegedNewObject(constructor, objectArray), LiveConnectPrivilegedActions.createAccessControllerContext(string));
    }

    public static Object invoke(Object object, Method method, Object[] objectArray, String string) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, method.getDeclaringClass());
        return AccessController.doPrivileged(new PrivilegedInvoke(object, method, objectArray), LiveConnectPrivilegedActions.createAccessControllerContext(string));
    }

    public static Object getField(Field field, Object object, String string) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, field.getDeclaringClass());
        return AccessController.doPrivileged(new PrivilegedGetField(field, object), LiveConnectPrivilegedActions.createAccessControllerContext(string));
    }

    public static void setField(Field field, Object object, Object object2, String string) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, field.getDeclaringClass());
        AccessController.doPrivileged(new PrivilegedSetField(field, object, object2), LiveConnectPrivilegedActions.createAccessControllerContext(string));
    }

    private static void originCheck(String string, Class clazz) throws OriginNotAllowedException {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            return;
        }
        URL uRL = codeSource.getLocation();
        URL uRL2 = null;
        if (string != null) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
        if (uRL != null && uRL2 != null) {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            try {
                inetAddress = InetAddress.getByName(uRL.getHost());
                inetAddress2 = InetAddress.getByName(uRL2.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()) && (inetAddress != null && inetAddress.equals(inetAddress2) || uRL.getHost().equalsIgnoreCase(uRL2.getHost())) && uRL.getPort() == uRL2.getPort()) {
                return;
            }
        }
        throw new OriginNotAllowedException("LiveConnect origin check failed for JavaScript trying to access Java object, caller=" + uRL2 + ", callee=" + uRL);
    }

    private static ProtectionDomain getProtectionDomain(String string) {
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = new CodeSource(uRL, null);
        final PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        if (uRL.getProtocol().equals("file")) {
            permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        } else {
            String string2 = uRL.getHost();
            if (string2 == null) {
                string2 = "localhost";
            }
            permissionCollection.add(new SocketPermission(string2, "connect,accept"));
        }
        return new LiveConnectProtectionDomain(permissionCollection);
    }

    private static AccessControlContext createAccessControllerContext(String string) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{LiveConnectPrivilegedActions.getProtectionDomain(string)};
        return new AccessControlContext(protectionDomainArray);
    }
}

