// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "utils.h"
#include "resource.h"


/**************************************/
/* Convert file exception to a string */
/**************************************/

CString ut_FileExceptionToString(int cause)
{
	CString s;

	switch(cause)
	{
		case CFileException::none:
			s.LoadString(CFE_NONE);
			break;
		case CFileException::fileNotFound:
			s.LoadString(CFE_FILENOTFOUND);
			break;
		case CFileException::badPath:
			s.LoadString(CFE_BADPATH);
			break;
		case CFileException::tooManyOpenFiles:
			s.LoadString(CFE_TOOMANYOPENFILES);
			break;
		case CFileException::accessDenied:
			s.LoadString(CFE_ACCESSDENIED);
			break;
		case CFileException::invalidFile:
			s.LoadString(CFE_INVALIDFILE);
			break;
		case CFileException::removeCurrentDir:
			s.LoadString(CFE_REMOVECWD);
			break;
		case CFileException::directoryFull:
			s.LoadString(CFE_DIRECTORYFULL);
			break;
		case CFileException::badSeek:
			s.LoadString(CFE_BADSEEK);
			break;
		case CFileException::hardIO:
			s.LoadString(CFE_HARDIO);
			break;
		case CFileException::sharingViolation:
			s.LoadString(CFE_SHAREVIOLATION);
			break;
		case CFileException::lockViolation:
			s.LoadString(CFE_LOCKVIOLATION);
			break;
		case CFileException::diskFull:
			s.LoadString(CFE_DISKFULL);
			break;
		case CFileException::endOfFile:
			s.LoadString(CFE_ENDOFFILE);
			break;
		default:
			s.LoadString(CFE_GENERIC);
			break;
	}
	return s;
}


/***************************/
/* Write a CString to disk */
/***************************/

void ut_WriteString(CFile& file,const CString& str)
{
// write the length of the string, a space and then the string itself followed by \r\n

  char buffer[20];
  wsprintf(buffer,"%d ",(int)str.GetLength());
  file.Write(buffer,lstrlen(buffer));

  file.Write((const char *)str,str.GetLength());
  file.Write("\r\n",2);
}


/********************************/
/* Write a string array to disk */
/********************************/

void ut_WriteStringArray(CFile& file,const CStringArray& str)
{
  ut_WriteLong(file,str.GetSize());
  for(int i=0;i<str.GetSize();i++)
    ut_WriteString(file,str[i]);
}


/****************************/
/* Read a CString from disk */
/****************************/

CString ut_ReadString(CFile& file)
{
// read the length of the string (terminated by a space)

  char buffer[128];
  for(int i=0;;i++)
  {
    file.Read(&buffer[i],1);
    if(buffer[i]==' ')
      break;
  }
  buffer[i]='\0';

  unsigned long length;
  sscanf(buffer,"%lu",&length);

// read the string itself

  char *tempbuf=(char *)GlobalAlloc(GPTR,length+1);   // get memory for it
  ASSERT(tempbuf!=NULL);

  file.Read(tempbuf,length);                    // read the string
  file.Read(buffer,2);                          // read and discard the \r\n
  CString str(tempbuf);                         // create the CString

  GlobalFree((HGLOBAL)tempbuf);                 // free memory
  return str;
}


/*********************************/
/* Read a string array from disk */
/*********************************/

void ut_ReadStringArray(CFile& file,CStringArray& array)
{
  int count=(int)ut_ReadLong(file);
  array.RemoveAll();

  for(int i=0;i<count;i++)
    array.Add(ut_ReadString(file));
}


/****************************/
/* Write an integer to disk */
/****************************/

void ut_WriteLong(CFile& file,unsigned long value)
{
  char buffer[128];
  wsprintf(buffer,"%lu\r\n",value);
  file.Write(buffer,lstrlen(buffer));
}


/*****************************/
/* Read an integer from disk */
/*****************************/

unsigned long ut_ReadLong(CFile& file)
{
  char buffer[128];

  for(int i=0;;i++)
  {
    file.Read(&buffer[i],1);
    if(buffer[i]=='\r')
      break;
  }

  file.Read(&buffer[i],1);
  buffer[i]='\0';

  unsigned long value;
  sscanf(buffer,"%lu",&value);

  return value;
}
