// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __SRVARRAY_H
#define __SRVARRAY_H


// class to hold unique array of servers and ports

class CServerArray
{
protected:
  CStringArray m_Servers;                       // format is "server/port"

public:
  CServerArray();
  ~CServerArray();

  int GetSize(void) const;                      // return the size
  BOOL Add(const CString& server,unsigned short port);  // add to the array
  void RemoveAt(const int index);               // remove from the array
  void GetAt(const int index,CString& server,unsigned short& port);

  void Read(CFile& file);                       // read from disk
  void Write(CFile& file);                      // write to disk
};

// include the inline members

#include "srvarray.inl"


#endif
