// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "srvarray.h"
#include "utils.h"


/***************/
/* Constructor */
/***************/

CServerArray::CServerArray()
{
}


/**************/
/* Destructor */
/**************/

CServerArray::~CServerArray()
{
}


/*******************************/
/* Add an element to the array */
/*******************************

element must be unique, TRUE returned if added, FALSE otherwise */

BOOL CServerArray::Add(const CString& server,unsigned short port)
{
// make up server/port

  char buffer[20];
  wsprintf(buffer,"%hu",port);
  CString str=server+CString('/')+CString(buffer);

// check the array and add if not already there

  for(int i=0;i<m_Servers.GetSize();i++)
    if(!m_Servers[i].CompareNoCase(str))
      return FALSE;

  m_Servers.Add(str);
  return TRUE;
}


/**********************************/
/* Remove a server from the array */
/**********************************/

void CServerArray::RemoveAt(const int index)
{
  ASSERT(index>=0 && index<=m_Servers.GetSize());
  m_Servers.RemoveAt(index);
}


/******************************/
/* Return element at position */
/******************************/

void CServerArray::GetAt(const int index,CString& server,unsigned short& port)
{
  ASSERT(index>=0 && index<=m_Servers.GetSize());

// get position of / separator

  int pos=m_Servers[index].Find('/');
  ASSERT(pos!=-1);

// get the server

  server=m_Servers[index].Left(pos);
  unsigned short ps;

// and the port

  sscanf((const char *)m_Servers[index].Right(m_Servers[index].GetLength()-pos-1),"%hu",&ps);
  port=ps;
}


/******************/
/* Read from disk */
/******************/

void CServerArray::Read(CFile& file)
{
  ut_ReadStringArray(file,m_Servers);
}


/*****************/
/* Write to disk */
/*****************/

void CServerArray::Write(CFile& file)
{
  ut_WriteStringArray(file,m_Servers);
}
