// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "SKSPclnt.h"
#include "search.h"
#include "srchdlg.h"
#include "spin.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


int CSearchDlg::m_SecondsInt=30;


/****************/
/* Construction */
/****************/

CSearchDlg::CSearchDlg(CWnd *pParent)
{
  if(!Create(CSearchDlg::IDD,pParent))
    TRACE("Unable to create dlg using template ID %d\n",CSearchDlg::IDD);

  MYAPP->m_bViewingSearches=TRUE;

	//{{AFX_DATA_INIT(CSearchDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


/**************/
/* Destructor */
/**************/

CSearchDlg::~CSearchDlg()
{
  MYAPP->m_bViewingSearches=FALSE;
}


/*************************/
/* Dynamic data exchange */
/*************************/

void CSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSearchDlg)
	DDX_Control(pDX, IDC_PRIORITY, m_Priority);
	DDX_Control(pDX, IDC_RESUME, m_Resume);
	DDX_Control(pDX, IDC_ABORT, m_Abort);
	DDX_Control(pDX, IDC_REMOVE, m_Remove);
	DDX_Control(pDX, IDC_PAUSE, m_Pause);
	DDX_Control(pDX, IDC_LIST, m_List);
	DDX_Control(pDX, IDC_SET, m_Set);
	DDX_Control(pDX, IDC_SECONDS, m_Seconds);
	//}}AFX_DATA_MAP
}


/***************/
/* Message map */
/***************/

BEGIN_MESSAGE_MAP(CSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CSearchDlg)
	ON_WM_VSCROLL()
	ON_EN_CHANGE(IDC_SECONDS, OnChangeSeconds)
	ON_BN_CLICKED(IDC_SET, OnSet)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	ON_BN_CLICKED(IDC_PAUSE, OnPause)
	ON_BN_CLICKED(IDC_RESUME, OnResume)
	ON_LBN_SELCHANGE(IDC_LIST, OnSelchangeList)
	ON_BN_CLICKED(IDC_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_ABORT, OnAbort)
	ON_CBN_SELCHANGE(IDC_PRIORITY, OnSelchangePriority)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/*****************/
/* Dialog cancel */
/*****************/

void CSearchDlg::OnCancel()
{
  KillTimer(ID_TIMER);
  DestroyWindow();
}


/*********************/
/* OK button pressed */
/*********************/

void CSearchDlg::OnOK()
{
  if(!UpdateData(TRUE))
  {
    TRACE0("UpdateData fail - modeless dlg terminate\n");
      return;
  }

  KillTimer(ID_TIMER);
  DestroyWindow();
}


/*********************/
/* Final termination */
/*********************/

void CSearchDlg::PostNcDestroy() 
{
  delete this;
}


/*************************/
/* Dialog initialisation */
/*************************/

BOOL CSearchDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();		

// set the seconds display

  char buffer[20];
  wsprintf(buffer,"%d",m_SecondsInt);
  m_Seconds.SetWindowText(CString(buffer));

// initialise the spinner control

  CSpinControl *pSpin=(CSpinControl *)GetDlgItem(IDC_SCSECONDS);
  ASSERT(pSpin!=NULL);
  pSpin->SetAssociate(this);

// update the list

  m_List.SetFont(&MYAPP->m_SwissFont);
  UpdateList();

// start the timer

  if(SetTimer(ID_TIMER,m_SecondsInt*1000,NULL)==0)
    AfxMessageBox(ERR_TIMERS);

	return TRUE;
}


/*************************************/
/* VSCROLL messages from the spinner */
/*************************************/

void CSearchDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);

// get the displacement requested by the user

	int nDelta=0;

	if (nSBCode==SB_LINEDOWN)
		nDelta=-1;
	else if(nSBCode==SB_LINEUP)
		nDelta=+1;
	else
		return; 																		// nothing special

// set the new value to the edit control

	BOOL bOK;
	int nNew=(int)GetDlgItemInt(IDC_SECONDS,&bOK)+nDelta;

	if(nNew>=1 && nNew<=360)
	{
		if(bOK)
			SetDlgItemInt(IDC_SECONDS,nNew);
		else
			MessageBeep((UINT)-1);
	}

// set focus to control and select everything in it

  m_Seconds.SetFocus();
	m_Seconds.SetSel(0,-1);
}


/*********************************/
/* Enable/disable the Set button */
/*********************************/

void CSearchDlg::OnChangeSeconds() 
{
  BOOL bOK;

  int seconds=(int)GetDlgItemInt(IDC_SECONDS,&bOK);
  m_Set.EnableWindow(seconds>=1 && seconds<=360 && bOK);
}


/*******************/
/* Set a new timer */
/*******************/

void CSearchDlg::OnSet() 
{
  BOOL bOK;
  int seconds=(int)GetDlgItemInt(IDC_SECONDS,&bOK);
	if(bOK)
  {
    KillTimer(ID_TIMER);
    if(SetTimer(ID_TIMER,seconds*1000,NULL)==0)
      AfxMessageBox(ERR_TIMERS);

    m_SecondsInt=seconds;
  }
}


/***********************************/
/* Timer callback, update the list */
/***********************************/

void CSearchDlg::OnTimer(UINT nIDEvent) 
{	
  UpdateList();
	CDialog::OnTimer(nIDEvent);
}


/****************************/
/* Manually update the list */
/****************************/

void CSearchDlg::OnUpdate() 
{
	UpdateList();
}


/*******************/
/* Update the list */
/*******************/

void CSearchDlg::UpdateList(void)
{
  CSearch *searches=&MYAPP->m_Search;
  CString separator(" : ");

  int selected=m_List.GetCurSel();
  m_List.SetRedraw(FALSE);
  m_List.ResetContent();

// loop through each thread

  for(int i=0;i<searches->m_Threads.GetSize();i++)
  {
  // add the description

    SEARCHDATA *sd=(SEARCHDATA *)searches->m_ThreadData[i];
    CString str(sd->project->GetDescription());
    str+=separator;

  // add the state of the thread

    DWORD state;
    ::GetExitCodeThread(((CWinThread *)searches->m_Threads[i])->m_hThread,&state);
    if(state==STILL_ACTIVE)
    {
      if(searches->m_SuspendedThreads[i]==TRUE)
        str+="PAUSED";
      else
        str+="ACTIVE";
    }
    else
    {
      if(state==0)                              // failed search
        str+="FINISHED";
      else
        str+="FOUND";
    }
    str+=separator;

  // add on the real-time information from the thread

    str+=((SEARCHDATA *)searches->m_ThreadData[i])->result;

  // add the string to the list box

    m_List.AddString(str);
  }

  m_List.SetRedraw(TRUE);
  if(selected!=LB_ERR && selected<m_List.GetCount())
    m_List.SetCurSel(selected);

  SetControls();
}


/*************************************/
/* Suspend the execution of a thread */
/*************************************/

void CSearchDlg::OnPause() 
{
// get the selected item

  int index=m_List.GetCurSel();
  if(index==LB_ERR)
    return;

// if not already suspended, and is active, then suspend

  if(!MYAPP->m_Search.m_SuspendedThreads[index])
  {
    DWORD state;
    ::GetExitCodeThread(((CWinThread *)MYAPP->m_Search.m_Threads[index])->m_hThread,&state);
    if(state==STILL_ACTIVE)
    {
      ((CWinThread *)MYAPP->m_Search.m_Threads[index])->SuspendThread();
      MYAPP->m_Search.m_SuspendedThreads[index]=TRUE;
      UpdateList();
    }
  }
}


/********************************/
/* Resume execution of a thread */
/********************************/

void CSearchDlg::OnResume() 
{
// get the selected item

  int index=m_List.GetCurSel();
  if(index==LB_ERR)
    return;

// if suspended, and is active, then resume

  if(MYAPP->m_Search.m_SuspendedThreads[index])
  {
    DWORD state;
    ::GetExitCodeThread(((CWinThread *)MYAPP->m_Search.m_Threads[index])->m_hThread,&state);
    if(state==STILL_ACTIVE)
    {
      ((CWinThread *)MYAPP->m_Search.m_Threads[index])->ResumeThread();
      MYAPP->m_Search.m_SuspendedThreads[index]=FALSE;
      UpdateList();
    }
  }
}


/********************/
/* Set the controls */
/********************/

void CSearchDlg::OnSelchangeList() 
{
  SetControls();	
}


/**************************/
/* Enable/disable buttons */
/**************************/

void CSearchDlg::SetControls(void)
{
  int selected=m_List.GetCurSel();
  BOOL suspended,active,bEnable=selected!=LB_ERR;
  CSearch *s=&MYAPP->m_Search;

  if(bEnable)
  {
    DWORD state;
    ::GetExitCodeThread(((CWinThread *)s->m_Threads[selected])->m_hThread,&state);
    if(state==STILL_ACTIVE)
    {
      suspended=s->m_SuspendedThreads[selected]==TRUE;
      active=TRUE;

      m_Priority.EnableWindow(TRUE);
      GetDlgItem(IDC_PRIORITYTEXT)->EnableWindow(TRUE);

      int index;
      switch(((CWinThread *)s->m_Threads[selected])->GetThreadPriority())
      {
        case THREAD_PRIORITY_HIGHEST:
          index=0;
          break;
        case THREAD_PRIORITY_ABOVE_NORMAL:
          index=1;
          break;
        case THREAD_PRIORITY_NORMAL:
          index=2;
          break;
        case THREAD_PRIORITY_BELOW_NORMAL:
          index=3;
          break;
        case THREAD_PRIORITY_LOWEST:
          index=4;
          break;
      }
      m_Priority.SetCurSel(index);
    }
    else
      active=FALSE;
  }
  
  if(!active || !bEnable)
  {
    m_Priority.EnableWindow(FALSE);
    GetDlgItem(IDC_PRIORITYTEXT)->EnableWindow(FALSE);
  }

  m_Remove.EnableWindow(bEnable && !active);
  m_Abort.EnableWindow(bEnable && active && !suspended && !((SEARCHDATA *)s->m_ThreadData[selected])->abortnow);
  m_Pause.EnableWindow(bEnable && active && !suspended);
  m_Resume.EnableWindow(bEnable && active && suspended);
}


/*********************************/
/* Remove a search from the list */
/*********************************/

void CSearchDlg::OnRemove() 
{
// check that the thread is not running

  int selected=m_List.GetCurSel();
  if(selected==LB_ERR)
    return;

  CSearch *s=&MYAPP->m_Search;
  DWORD state;

  ::GetExitCodeThread(((CWinThread *)s->m_Threads[selected])->m_hThread,&state);
  if(state==STILL_ACTIVE)
    return;

// remind the user to update the information if the search wasn't aborted

  if(!((SEARCHDATA *)s->m_ThreadData[selected])->abortnow)
    if(AfxMessageBox(IDS_SEARCHREMINDER,MB_OKCANCEL|MB_ICONEXCLAMATION)==IDCANCEL)
      return;

// remove from arrays and redraw

  delete (CWinThread *)s->m_Threads[selected];

  SEARCHDATA *sd=(SEARCHDATA *)s->m_ThreadData[selected];
  delete sd->project;
  delete sd->keystr;
  GlobalFree((HGLOBAL)sd->result);
  delete sd;

  s->m_Threads.RemoveAt(selected);
  s->m_ThreadData.RemoveAt(selected);
  s->m_SuspendedThreads.RemoveAt(selected);

  UpdateList();
}


/***********************************/
/* Abort the execution of a thread */
/***********************************/

void CSearchDlg::OnAbort() 
{
// offer the user a chance to back off

  if(AfxMessageBox(IDS_ABORTSEARCH,MB_YESNO|MB_ICONEXCLAMATION)==IDNO)
    return;

// check that the thread is running

  int selected=m_List.GetCurSel();
  if(selected==LB_ERR)
    return;

  CSearch *s=&MYAPP->m_Search;
  DWORD state;

  ::GetExitCodeThread(((CWinThread *)s->m_Threads[selected])->m_hThread,&state);
  if(state!=STILL_ACTIVE)
    return;  	

// send the thread notification that it should abort

  ((SEARCHDATA *)s->m_ThreadData[selected])->abortnow=TRUE;
  strcpy(((SEARCHDATA *)s->m_ThreadData[selected])->result,"aborting...");

  UpdateList();
}


/***************************/
/* Thread priority changed */
/***************************/

void CSearchDlg::OnSelchangePriority() 
{
// get selected thread

  int selected=m_List.GetCurSel();
  if(selected==LB_ERR)
    return;

// get selected priority

  int priority_index=m_Priority.GetCurSel();
  if(priority_index==CB_ERR)
    return;

// translate to priority number

  int newpriority;
  switch(priority_index)
  {
    case 0:
      newpriority=THREAD_PRIORITY_HIGHEST;
      break;
    case 1:
      newpriority=THREAD_PRIORITY_ABOVE_NORMAL;
      break;
    case 2:
      newpriority=THREAD_PRIORITY_NORMAL;
      break;
    case 3:
      newpriority=THREAD_PRIORITY_BELOW_NORMAL;
      break;
    case 4:
      newpriority=THREAD_PRIORITY_LOWEST;
      break;
  }

// set new priority

  ((CWinThread *)MYAPP->m_Search.m_Threads[selected])->SetThreadPriority(newpriority);
}
