// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __SPIN_H
#define __SPIN_H

#include "muscrl32.h"


class CSpinControl : public CWnd
{
	DECLARE_DYNAMIC(CSpinControl)

public:
	CSpinControl();
	BOOL Create(DWORD dwStyle,const RECT& rect,CWnd *pParentWnd,UINT nID);

	CWnd* GetAssociate();
	void SetAssociate(CWnd* pNew);
	void GetRange(UINT& iMin,UINT& iMax);
	void SetRange(UINT iMin,UINT iMax);
	UINT GetCurrentPos();
	void SetCurrentPos(UINT iPos);

protected:
	virtual WNDPROC* GetSuperWndProcAddr();
};


/**************************/
/* Do nothing constructor */
/**************************/

inline CSpinControl::CSpinControl()
{
}


/****************************/
/* Get the associate window */
/****************************/

inline CWnd* CSpinControl::GetAssociate()
{
	return CWnd::FromHandle((HWND)SendMessage(MSM_HWNDASSOCIATEGET));
}


/****************************/
/* Set the associate window */
/****************************/

inline void CSpinControl::SetAssociate(CWnd* pNew)
{
	SendMessage(MSM_HWNDASSOCIATESET, (UINT)pNew->GetSafeHwnd());
}


/*************************/
/* Get the current range */
/*************************/

inline void CSpinControl::GetRange(UINT& iMin, UINT& iMax)
{
	DWORD dw=SendMessage(MSM_DWRANGEGET);
	iMin=LOWORD(dw);
	iMax = HIWORD(dw);
}


/**********************/
/* Set the spin range */
/**********************/

inline void CSpinControl::SetRange(UINT iMin, UINT iMax)
{
	SendMessage(MSM_DWRANGESET, 0, MAKELONG(iMin, iMax));
}


/*********************************/
/* Get the current spin position */
/*********************************/

inline UINT CSpinControl::GetCurrentPos()
{
	return (UINT)SendMessage(MSM_WCURRENTPOSGET);
}


/****************************/
/* Set the current position */
/****************************/

inline void CSpinControl::SetCurrentPos(UINT iPos)
{
	SendMessage(MSM_WCURRENTPOSSET,iPos);
}


#endif
