// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#include "stdafx.h"
#include "SKSPclnt.h"
#include "mainfrm.h"
#include "cldoc.h"
#include "clview.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/***************/
/* Message map */
/***************/

BEGIN_MESSAGE_MAP(CClientApp, CWinApp)
	//{{AFX_MSG_MAP(CClientApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()


/****************/
/* Construction */
/****************/

CClientApp::CClientApp()
{
  m_First=TRUE;
  m_ViewWnd=NULL;
  m_bViewingSearches=FALSE;
}


// the one and only application class

CClientApp theApp;


/****************************/
/* Initialise this instance */
/****************************/

BOOL CClientApp::InitInstance()
{
	Enable3dControls();
	LoadStdProfileSettings(0);            // Load standard INI file options (including MRU)

// Register the application's document templates.  Document templates
//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CClientDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CClientView));
	AddDocTemplate(pDocTemplate);

// create a new (empty) document

	OnFileNew();

// initialise the MicroScroll library

	if((hMicroScroll=LoadLibrary("MUSCRL32.DLL"))==NULL)
	{
		AfxMessageBox("Could not load MUSCRL32.DLL");
		return FALSE;
	}

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}

	HDC hdc=CreateIC("DISPLAY",NULL,NULL,NULL);
	m_SwissFont.CreateFont(
			-MulDiv(8,GetDeviceCaps(hdc,LOGPIXELSY),72),		// height
			0,																							// width
			0,																							// escapement
			0,																							// orientation
			FW_NORMAL,																			// weight
			0,																							// italic
			0,																							// underline
			0,																							// strikeout
			DEFAULT_CHARSET,																// character set
			OUT_DEFAULT_PRECIS,															// precision
			CLIP_DEFAULT_PRECIS,														// clip precision
			DEFAULT_QUALITY,																// quality
			VARIABLE_PITCH|FF_SWISS,												// pitch & family
			"MS Sans Serif"
		);
	DeleteDC(hdc);

	return TRUE;
}


/*******************/
/* About... dialog */
/*******************/

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CClientApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


/****************************************************/
/* Used once to initialise the controls in the view */
/****************************************************/

BOOL CClientApp::OnIdle(LONG lCount) 
{
  if(m_First && m_ViewWnd)
  {
    m_ViewWnd->RefillProjectList();
    m_ViewWnd->RefillKeysList();
    m_ViewWnd->RefillServerList();
    m_ViewWnd->SetControls();
    m_ViewWnd->EnableRetrieve();
    m_First=FALSE;
  }
	return CWinApp::OnIdle(lCount);
}


/***********************/
/* Application exiting */
/***********************/

int CClientApp::ExitInstance() 
{	
// remove MUSCROLL.DLL

	if(hMicroScroll!=NULL)
		FreeLibrary(hMicroScroll);

	return CWinApp::ExitInstance();
}
