// Simple Key Search Protocol Client
// (c) Andy Brown 1995


#ifndef __SKSP_H
#define __SKSP_H


#include <winsock.h>

// a class to manage communication with a server

class CSKSP
{
protected:
  SOCKET m_Socket;                              // communications socket
  CString m_ErrorString;                        // server returned error
  CStringArray m_ReturnData;                    // anything the server returns
  CString m_Advice;                             // 222 advice returned from server
  int m_State;                                  // comms state

	CString m_WriteBuffer;		    								// data ready to write out
	CString m_ReadBuffer;											    // data being read in

  CString m_Email;                              // email address (HELO command)
  CString m_Name;                               // unique name (HELO command)
  CString m_Command;                            // command to write

	enum																			    // possible internal states
	{
    Ready,                                      // inactive
    Connecting,                                 // connecting to server
		ReadingGreeting,												    // reading the greeting
		WritingHelo,														    // writing the HELO command
		ReadingHeloReply,												    // reading reply to HELO
    WritingComm,                                // writing the COMM command
    ReadingCommReply,                           // reading reply to COMM
		WritingCommand,													    // writing request
		ReadingReplyCode,												    // read the reply to the request
    ReadingDataReply,                           // reading multi-line reply
		WritingQuit,											          // writing the QUIT command
		ReadingQuitReply												    // reading reply to QUIT
	};

  BOOL IsIPAddress(const CString& host);        // does this look like an IP address?
  void SendUpdate(UINT msg) const;              // send a message to the view
  void AdvanceToNextState(void);                // advance to next processing state
  int ConvertSKSPError(const CString& errstr);  // convert SKSP to resource ID
  void ProcessReadbuffer(void);                 // process the read buffer

public:
  CSKSP();                                      // constructor
  ~CSKSP();                                     // destructor

  void Start(CWnd *wnd,
             const CString& server,
             unsigned short port,
             const CString& email,
             const CString& name,
             const CString& command);           // start the session

  BOOL IsError(void) const;                     // is an error condition?
  BOOL IsRunning(void) const;                   // is there an active session
  void DisplayError(void) const;                // show a message box
  void Abort(void);                             // forcibly close the connection
  static int ConvertSocketError(const int err); // winsock error->resource ID

  CStringArray *GetReturnData(void);            // get data returned by server
  CString GetStateString(void) const;           // get a descriptive state string
  CString GetCommand(void) const;               // get the command
  CString GetAdvice(void) const;                // get server advice, if any

  void Read(void);    						        			// data is ready to be received
	void Write(void);		    						          // socket is ready for writing
	void Connect(void);	            						  // connect event received
  void Close(void);                             // socket closed
};

// include the inline members

#include "sksp.inl"


#endif
